package com.biz.crm.common.form.simple.vo;

import java.math.BigDecimal;
import java.util.List;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.simple.widget.IntelOrAmdSelectWidget;

/**
 * 各种配件信息，配件信息使用抽象动态表单在前端进行显示
 * @author yinwenjie
 */
public abstract class Accessory implements DynamicForm {
  
  /**
   * 对应的PC配置单的编号
   */
  private String parentCode;
  
  /**
   * 业务Key值
   */
  private String dynamicKey;
  
  @DynamicField(fieldName = "父类字段1" , modifiable = true , required = false , controllKey = IntelOrAmdSelectWidget.class)
  private String accessoryFielda;
  
  @DynamicField(fieldName = "父类字段2" , modifiable = false , required = true , controllKey = IntelOrAmdSelectWidget.class)
  private BigDecimal accessoryFieldb;
  
  @DynamicField(fieldName = "父类关联对象1" , modifiable = false , required = false , controllKey = IntelOrAmdSelectWidget.class)
  private List<OtherForm> others; 
  
  @Override
  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getDynamicKey() {
    return dynamicKey;
  }

  public void setDynamicKey(String dynamicKey) {
    this.dynamicKey = dynamicKey;
  }
}
