package com.biz.crm.common.form.simple.vo;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * 竞品采集清单表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollectInventory", description = "竞品采集清单表")
public class CompetingGoodsCollectInventory extends UuidEntity {

  private static final long serialVersionUID = -2765289943786899179L;
  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  @Column(name = "collect_code", length = 64, nullable = false, columnDefinition = "VARCHAR2(64)")
  private String collectCode;

  /**
   * 竞品id
   */
  @ApiModelProperty("竞品id")
  @Column(name = "goods_id", length = 64, nullable = false, columnDefinition = "VARCHAR2(64)")
  @DynamicField(fieldName = "竞品id", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String goodsId;

  /**
   * 铺货数量
   */
  @ApiModelProperty("铺货数量")
  @Column(name = "goods_quantity", length = 8, nullable = false, columnDefinition = "int")
  @DynamicField(fieldName = "铺货数量", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private Integer goodsQuantity = 0;

}
