package com.biz.crm.common.form.simple.vo;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import com.biz.crm.common.form.simple.widget.IntelOrAmdSelectWidget;

import lombok.Getter;
import lombok.Setter;

/**
 * CPU配件
 * @author yinwenjie
 */
@Getter
@Setter
public class CpuAccessory extends Accessory {
  
  /**
   * CPU类型，1：Intel；0：AMD
   */
  @DynamicField(fieldName = "CPU类型" , modifiable = true , required = true 
      , validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = IntelOrAmdSelectWidget.class)
  private Integer type;
  /**
   * CPU序列号
   */
  @DynamicField(fieldName = "CPU序列号" , modifiable = true , required = true 
      , validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String serial;
  /**
   * CPU产地编号
   */
  @DynamicField(fieldName = "CPU产地" , modifiable = true , required = true 
      , validates = {@Validate(value = NotBlankValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String originCode;
}
