package com.biz.crm.common.form.simple.widget;

import java.util.Map;

import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.widget.WidgetKey;
import com.google.common.collect.Maps;

/**
 * 该控件属于本项目专用：来自于数据字典的付款类型
 * @author yinwenjie
 */
@Component
public class PaymentTypeSelectWidget implements WidgetKey {

  @Override
  public String widgetCode() {
    return "paymentTypeSelectWidget";
  }

  @Override
  public String widgetName() {
    return "项目A专用：付款类型";
  }

  @Override
  public Map<String, Object> widgetParam() {
    // 描述数据字典的固定code
    Map<String , Object> selectMappings = Maps.newLinkedHashMap();
    selectMappings.put("code", "paymentType");
    return selectMappings;
  }
}
