package com.biz.crm.common.form.simple.vo;

import java.math.BigDecimal;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.common.form.sdk.field.validate.RegExValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleDecimalInputWidget;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import com.biz.crm.common.form.simple.widget.PaymentTypeSelectWidget;

import lombok.Getter;
import lombok.Setter;

/**
 * 政府客户
 * @author yinwenjie
 */
@Getter
@Setter
public class OrgCustomer extends Customer {
  /**
   * 政府客户名称
   */
  @DynamicField(fieldName = "政府客户名称" , modifiable = true , required = true 
      , validates = {@Validate(value = NotBlankValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String orgName;
  /**
   * 折扣标准，例如8者，就是0.8
   */
  @DynamicField(fieldName = "折扣标准" , modifiable = true , required = true 
  , validates = {@Validate(value = NotNullValidateStrategy.class),
                 @Validate(value = RegExValidateStrategy.class , inputs = {"^[1-9]{1}\\.[0-9]{1,3}$"})} , controllKey = SimpleDecimalInputWidget.class)
  private BigDecimal discount;
  /**
   * 来自于数据字典的付款类型
   */
  @DynamicField(fieldName = "付款类型" , modifiable = true , required = true 
      , validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = PaymentTypeSelectWidget.class)
  private Integer paymentType;
}
