package com.biz.crm.common.form.simple.vo;

import java.util.Date;
import java.util.List;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleDateSelectWidget;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;

import lombok.Getter;
import lombok.Setter;

/**
 * 内存配件
 * @author yinwenjie
 */
@Getter
@Setter
public class MemoryAccessory extends Accessory {
  /**
   * 内存序号
   */
  @DynamicField(fieldName = "内存序号" , modifiable = true , required = true 
      , validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String serial;
  /**
   * 内存工作频率
   */
  @DynamicField(fieldName = "内存工作频率" , modifiable = true , required = true 
      , validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = SimpleInputWidget.class)
  private String hz;
  /**
   * 内存过期时间
   */
  @DynamicField(fieldName = "质保过期时间" , modifiable = true , required = true 
      , validates = {@Validate(value = NotNullValidateStrategy.class)} , controllKey = SimpleDateSelectWidget.class)
  private Date expireTime;
  
  @DynamicField(fieldName = "关联子表" , modifiable = true , required = true , controllKey = SimpleInputWidget.class)
  private List<CompetingGoodsCollect> competingGoodsCollects;
}
