package com.biz.crm.common.gaode.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.gaode.sdk.constant.GaoDeConstant;
import com.biz.crm.common.gaode.sdk.dto.GaoDeConvertDto;
import com.biz.crm.common.gaode.sdk.dto.QueryAroundDto;
import com.biz.crm.common.gaode.sdk.service.GaoDeAroundService;
import com.biz.crm.common.gaode.sdk.vo.GaoDeNearbyVo;
import com.biz.crm.common.gaode.sdk.vo.GaoDeResponseVo;
import com.biz.crm.common.gaode.sdk.vo.convert.GaoDeConvertVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 高德
 *
 * @author songjingen
 */
@Service
@Slf4j
public class GaoDeAroundServiceImpl implements GaoDeAroundService {

  @Value("${gaode.key:}")
  private String key;
  @Value("${gaode.radius:}")
  private String radius;
  @Value("${gaode.keywords:}")
  private String keywords;

  @Autowired
  @Qualifier("restTemplateRemote")
  private RestTemplate restTemplate;

  @Override
  public Page<GaoDeNearbyVo> findByConditions(QueryAroundDto dto) {
    if (StringUtils.isBlank(dto.getRadius())) {
      dto.setRadius(radius);
    }
    if (StringUtils.isBlank(dto.getKeywords())) {
      dto.setKeywords(keywords);
    }
    if (StringUtils.isBlank(key)
        || StringUtils.isBlank(dto.getRadius())
        || StringUtils.isBlank(dto.getKeywords())
    ) {
      throw new RuntimeException("请维护高德相关参数");
    }
    Map<String, String> uriVariables = new HashMap<>();
    StringBuffer url = new StringBuffer();
    url.append(GaoDeConstant.aroundUrl).append("?key=").append(key);
    url.append("&").append("location=").append(dto.getLocation());
    url.append("&").append("radius=").append(dto.getRadius());
    url.append("&").append("keywords=").append(dto.getKeywords());
    url.append("&").append("extensions=").append("all");
    url.append("&").append("offset=").append(dto.getOffset());
    url.append("&").append("page=").append(dto.getPage());
    log.info("请求高德附近门店url==> " + url.toString());
    ResponseEntity<String> resVoResponseEntity = restTemplate.getForEntity(url.toString(), String.class, uriVariables);
    String strRes = resVoResponseEntity.getBody();
    log.info("请求高德附近门店返回参数 ==> " + strRes);
    strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
    strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
    GaoDeResponseVo gaoDeResponseVo = JsonUtils.json2Obj(strRes, GaoDeResponseVo.class);
    Page<GaoDeNearbyVo> page = new Page<>();
    page.setTotal(Long.parseLong(gaoDeResponseVo.getCount()));
    page.setCurrent(Long.parseLong(dto.getPage()));
    page.setSize(Long.parseLong(dto.getOffset()));
    page.setRecords(gaoDeResponseVo.getPois());
    return page;
  }

  @Override
  public GaoDeNearbyVo findById(String id) {
    Map<String, String> uriVariables = new HashMap<>();
    StringBuffer url = new StringBuffer();
    url.append(GaoDeConstant.detailUrl).append("?key=").append(key);
    url.append("&").append("id=").append(id);
    log.info("请求高德ID查询url==> " + url.toString());
    ResponseEntity<String> resVoResponseEntity = restTemplate.getForEntity(url.toString(), String.class, uriVariables);
    String strRes = resVoResponseEntity.getBody();
    log.info("请求高德ID查询返回参数 ==> " + strRes);
    strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
    strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
    strRes = strRes.replaceAll("\"distance\":\\[]", "\"distance\":\"\"");
    GaoDeResponseVo gaoDeResponseVo = JsonUtils.json2Obj(strRes, GaoDeResponseVo.class);
    List<GaoDeNearbyVo> pois = gaoDeResponseVo.getPois();
    if (CollectionUtils.isEmpty(pois)) {
      return null;
    }
    return pois.get(0);
  }

  @Override
  public GaoDeConvertVo adressConvert(GaoDeConvertDto dto) {
    Validate.notNull(dto, "传入参数不能为空！");
    Validate.notBlank(dto.getLocation(), "传入经纬度坐标不能为空！");
    StringBuffer url = new StringBuffer();
    url.append(GaoDeConstant.convertUrl).append("?key=").append(key);
    url.append("&").append("location=").append(dto.getLocation());
    if (StringUtils.isNotBlank(dto.getPoitype())) {
      url.append("&").append("poitype=").append(dto.getPoitype());
    }
    String radius = StringUtils.isBlank(dto.getRadius()) ? "1000" : dto.getRadius();
    url.append("&").append("radius=").append(radius);
    String extensions = StringUtils.isBlank(dto.getExtensions()) ? "base" : dto.getExtensions();
    url.append("&").append("extensions=").append(extensions);
    String roadlevel = StringUtils.isBlank(dto.getRoadlevel()) ? "0" : dto.getRoadlevel();
    url.append("&").append("roadlevel=").append(roadlevel);
    if (StringUtils.isNotBlank(dto.getHomeorcorp())) {
      url.append("&").append("homeorcorp=").append(dto.getHomeorcorp());
    }
    log.info("请求高德地址转换查询url==> {}", url.toString());
    String result = restTemplate.getForEntity(url.toString(), String.class).getBody();
    log.info("请求高德地址转换查询返回参数 ==> {}" , result);
    GaoDeConvertVo convertVo = JSONObject.parseObject(result, GaoDeConvertVo.class);
    if (BooleanEnum.TRUE.getNumStr().equals(convertVo.getStatus())) {
      return convertVo;
    }
    return new GaoDeConvertVo();
  }

}
