/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.gaode.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.gaode.sdk.dto.GaoDeConvertDto;
import com.biz.crm.common.gaode.sdk.dto.QueryAroundDto;
import com.biz.crm.common.gaode.sdk.service.GaoDeAroundService;
import com.biz.crm.common.gaode.sdk.vo.GaoDeNearbyVo;
import com.biz.crm.common.gaode.sdk.vo.GaoDeResponseVo;
import com.biz.crm.common.gaode.sdk.vo.convert.GaoDeConvertVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class GaoDeAroundServiceImpl
implements GaoDeAroundService {
    private static final Logger log = LoggerFactory.getLogger(GaoDeAroundServiceImpl.class);
    @Value(value="${gaode.key:}")
    private String key;
    @Value(value="${gaode.radius:}")
    private String radius;
    @Value(value="${gaode.keywords:}")
    private String keywords;
    @Autowired
    @Qualifier(value="restTemplateRemote")
    private RestTemplate restTemplate;

    public Page<GaoDeNearbyVo> findByConditions(QueryAroundDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getRadius())) {
            dto.setRadius(this.radius);
        }
        if (StringUtils.isBlank((CharSequence)dto.getKeywords())) {
            dto.setKeywords(this.keywords);
        }
        if (StringUtils.isBlank((CharSequence)this.key) || StringUtils.isBlank((CharSequence)dto.getRadius()) || StringUtils.isBlank((CharSequence)dto.getKeywords())) {
            throw new RuntimeException("\u8bf7\u7ef4\u62a4\u9ad8\u5fb7\u76f8\u5173\u53c2\u6570");
        }
        HashMap uriVariables = new HashMap();
        StringBuffer url = new StringBuffer();
        url.append("https://restapi.amap.com/v3/place/around").append("?key=").append(this.key);
        url.append("&").append("location=").append(dto.getLocation());
        url.append("&").append("radius=").append(dto.getRadius());
        url.append("&").append("keywords=").append(dto.getKeywords());
        url.append("&").append("extensions=").append("all");
        url.append("&").append("offset=").append(dto.getOffset());
        url.append("&").append("page=").append(dto.getPage());
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u9644\u8fd1\u95e8\u5e97url==> " + url.toString());
        ResponseEntity resVoResponseEntity = this.restTemplate.getForEntity(url.toString(), String.class, uriVariables);
        String strRes = (String)resVoResponseEntity.getBody();
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u9644\u8fd1\u95e8\u5e97\u8fd4\u56de\u53c2\u6570 ==> " + strRes);
        strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
        strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
        GaoDeResponseVo gaoDeResponseVo = (GaoDeResponseVo)JsonUtils.json2Obj((String)strRes, GaoDeResponseVo.class);
        Page page = new Page();
        page.setTotal(Long.parseLong(gaoDeResponseVo.getCount()));
        page.setCurrent(Long.parseLong(dto.getPage()));
        page.setSize(Long.parseLong(dto.getOffset()));
        page.setRecords(gaoDeResponseVo.getPois());
        return page;
    }

    public GaoDeNearbyVo findById(String id) {
        HashMap uriVariables = new HashMap();
        StringBuffer url = new StringBuffer();
        url.append("https://restapi.amap.com/v3/place/detail").append("?key=").append(this.key);
        url.append("&").append("id=").append(id);
        log.info("\u8bf7\u6c42\u9ad8\u5fb7ID\u67e5\u8be2url==> " + url.toString());
        ResponseEntity resVoResponseEntity = this.restTemplate.getForEntity(url.toString(), String.class, uriVariables);
        String strRes = (String)resVoResponseEntity.getBody();
        log.info("\u8bf7\u6c42\u9ad8\u5fb7ID\u67e5\u8be2\u8fd4\u56de\u53c2\u6570 ==> " + strRes);
        strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
        strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
        strRes = strRes.replaceAll("\"distance\":\\[]", "\"distance\":\"\"");
        GaoDeResponseVo gaoDeResponseVo = (GaoDeResponseVo)JsonUtils.json2Obj((String)strRes, GaoDeResponseVo.class);
        List pois = gaoDeResponseVo.getPois();
        if (CollectionUtils.isEmpty((Collection)pois)) {
            return null;
        }
        return (GaoDeNearbyVo)pois.get(0);
    }

    public GaoDeConvertVo adressConvert(GaoDeConvertDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getLocation(), (String)"\u4f20\u5165\u7ecf\u7eac\u5ea6\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        StringBuffer url = new StringBuffer();
        url.append("https://restapi.amap.com/v3/geocode/regeo").append("?key=").append(this.key);
        url.append("&").append("location=").append(dto.getLocation());
        if (StringUtils.isNotBlank((CharSequence)dto.getPoitype())) {
            url.append("&").append("poitype=").append(dto.getPoitype());
        }
        String radius = StringUtils.isBlank((CharSequence)dto.getRadius()) ? "1000" : dto.getRadius();
        url.append("&").append("radius=").append(radius);
        String extensions = StringUtils.isBlank((CharSequence)dto.getExtensions()) ? "base" : dto.getExtensions();
        url.append("&").append("extensions=").append(extensions);
        String roadlevel = StringUtils.isBlank((CharSequence)dto.getRoadlevel()) ? "0" : dto.getRoadlevel();
        url.append("&").append("roadlevel=").append(roadlevel);
        if (StringUtils.isNotBlank((CharSequence)dto.getHomeorcorp())) {
            url.append("&").append("homeorcorp=").append(dto.getHomeorcorp());
        }
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u5730\u5740\u8f6c\u6362\u67e5\u8be2url==> {}", (Object)url.toString());
        String result = (String)this.restTemplate.getForEntity(url.toString(), String.class, new Object[0]).getBody();
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u5730\u5740\u8f6c\u6362\u67e5\u8be2\u8fd4\u56de\u53c2\u6570 ==> {}", (Object)result);
        GaoDeConvertVo convertVo = (GaoDeConvertVo)JSONObject.parseObject((String)result, GaoDeConvertVo.class);
        if (BooleanEnum.TRUE.getNumStr().equals(convertVo.getStatus())) {
            return convertVo;
        }
        return new GaoDeConvertVo();
    }
}

