package com.biz.crm.common.gaode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("高德查询参数dto")
public class GaoDeConvertDto {

    //必传参数
    @ApiModelProperty("经纬度坐标 传入内容规则：经度在前，纬度在后，经纬度间以“,”分割，经纬度小数点后不要超过 6 位 格式： 116.481488,39.990464")
    private String location;

    //选填参数
    //以下内容需要 extensions 参数为 all 时才生效。
    //逆地理编码在进行坐标解析之后不仅可以返回地址描述，也可以返回经纬度附近符合限定要求的 POI 内容（在 extensions 字段值为 all 时才会返回 POI 内容）。
    //设置 POI 类型参数相当于为上述操作限定要求。参数仅支持传入 POI TYPECODE，可以传入多个 POI TYPECODE，相互之间用“|”分隔。获取 POI TYPECODE 可以参考 POI 分类码表
    @ApiModelProperty("返回附近 POI 类型")
    private String poitype;

    //选填参数
    //radius 取值范围：0~3000，默认值：1000。单位：米
    @ApiModelProperty("搜索半径")
    private String radius;

    //选填参数
    //extensions 参数默认取值是 base，也就是返回基本地址信息；
    //extensions 参数取值为 all 时会返回基本地址信息、附近 POI 内容、道路信息以及道路交叉口信息。
    @ApiModelProperty("返回结果控制")
    private String extensions;

    //选填参数
    //以下内容需要 extensions 参数为 all 时才生效。
    //可选值：0，1  当 roadlevel=0时，显示所有道路 ； 当 roadlevel=1时，过滤非主干道路，仅输出主干道路数据
    @ApiModelProperty("道路等级")
    private String roadlevel;

    //选填参数
    @ApiModelProperty("数字签名")
    private String sig;

    //可选输入内容包括：JSON，XML。设置 JSON 返回结果数据将会以 JSON 结构构成；
    //如果设置 XML 返回结果数据将以 XML 结构构成。
    @ApiModelProperty("返回数据格式类型")
    private String output = "JSON";

    //callback 值是用户定义的函数名称，此参数只在 output 参数设置为 JSON 时有效。
    @ApiModelProperty("回调函数")
    private String callback;

    //以下内容需要 extensions 参数为 all 时才生效。
    //homeorcorp 参数的设置可以影响召回 POI 内容的排序策略，目前提供三个可选参数：
    //0：不对召回的排序策略进行干扰。
    //1：综合大数据分析将居家相关的 POI 内容优先返回，即优化返回结果中 pois 字段的poi 顺序。
    //2：综合大数据分析将公司相关的 POI 内容优先返回，即优化返回结果中 pois 字段的poi 顺序。
    @ApiModelProperty("是否优化 POI 返回顺序")
    private String homeorcorp;

}
