package com.biz.crm.common.gaode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("高德地址查询参数dto")
public class GaoDeInfoDto {

    //必传参数
    @ApiModelProperty("结构化地址信息 规则遵循：国家、省份、城市、区县、城镇、乡村、街道、门牌号码、屋邨、大厦，如：北京市朝阳区阜通东大街6号。")
    private String address;

    //选填参数
    //可选输入内容包括：指定城市的中文（如北京）、指定城市的中文全拼（beijing）、citycode（010）、adcode（110000），不支持县级市。当指定城市查询内容为空时，会进行全国范围内的地址转换检索。
    @ApiModelProperty("指定查询的城市")
    private String city;

    //选填参数
    @ApiModelProperty("数字签名")
    private String sig;

    //可选输入内容包括：JSON，XML。设置 JSON 返回结果数据将会以 JSON 结构构成；
    //如果设置 XML 返回结果数据将以 XML 结构构成。
    @ApiModelProperty("返回数据格式类型")
    private String output = "JSON";

    //callback 值是用户定义的函数名称，此参数只在 output 参数设置为 JSON 时有效。
    @ApiModelProperty("回调函数")
    private String callback;

}
