package com.biz.crm.common.gaode.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.gaode.sdk.dto.GaoDeConvertDto;
import com.biz.crm.common.gaode.sdk.dto.GaoDeInfoDto;
import com.biz.crm.common.gaode.sdk.dto.QueryAroundDto;
import com.biz.crm.common.gaode.sdk.vo.GaoDeInfoVo;
import com.biz.crm.common.gaode.sdk.vo.GaoDeNearbyVo;
import com.biz.crm.common.gaode.sdk.vo.convert.GaoDeConvertVo;

/**
 * 高德附近门店service
 *
 * @author songjingen
 */
public interface GaoDeAroundService {

  /**
   * 按照条件分页查询数
   *
   * @param dto
   * @return
   */
  Page<GaoDeNearbyVo> findByConditions(QueryAroundDto dto);

  /**
   * 根据id查询数据
   *
   * @param id
   * @return
   */
  GaoDeNearbyVo findById(String id);

  /**
   * 高德地址转换
   * @param dto
   * @return
   */
  GaoDeConvertVo adressConvert(GaoDeConvertDto dto);

  /**
   * 高德地址信息获取
   * @param dto
   * @return
   */
  GaoDeInfoVo adressInfo(GaoDeInfoDto dto);

}
