package com.biz.crm.common.gaode.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("地理编码信息列表")
public class GaoDeGeocodeVo {

    //例如：中国
    @ApiModelProperty("坐标点所在国家名称")
    private String country;

    //例如：北京市。此处需要注意的是，中国的四大直辖市也算作省级单位
    @ApiModelProperty("地址所在的省份名")
    private String province;

    //例如：北京市
    @ApiModelProperty("地址所在的城市名")
    private String city;

    //例如：010
    @ApiModelProperty("城市编码")
    private String citycode;

    //例如：朝阳区
    @ApiModelProperty("地址所在的区")
    private String district;

    @ApiModelProperty("镇")
    private String[] township;

    //例如：110101
    @ApiModelProperty("区域编码")
    private String adcode;

    //例如：阜通东大街
    @ApiModelProperty("街道")
    private String street;

    //例如：6号
    @ApiModelProperty("门牌")
    private String number;

    //经度，纬度
    @ApiModelProperty("坐标点")
    private String location;

    //参见下方的地理编码匹配级别列表
    @ApiModelProperty("匹配级别")
    private String level;

}
