package com.biz.crm.common.gaode.sdk.vo.convert;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("地址元素列表")
public class GaoDeAddressComponentVo {

    //例如：中国
    @ApiModelProperty("坐标点所在国家名称")
    private String country;

    //例如：北京市
    @ApiModelProperty("坐标点所在省名称")
    private String province;

    //请注意：当城市是省直辖县时返回为空，以及城市为北京、上海、天津、重庆四个直辖市时，该字段返回为空
    @ApiModelProperty("坐标点所在城市名称")
    private List<String> city;

    //例如：010
    @ApiModelProperty("城市编码")
    private String citycode;

    //例如：海淀区
    @ApiModelProperty("坐标点所在区")
    private String district;

    //例如：110108
    @ApiModelProperty("行政区编码")
    private String adcode;

    //例如：燕园街道
    @ApiModelProperty("坐标点所在乡镇/街道（此街道为社区街道，不是道路信息）")
    private String township;

    //例如：110101001000
    @ApiModelProperty("乡镇街道编码")
    private String towncode;

    //例如：渤海
    @ApiModelProperty("所属海域信息")
    private String seaArea;

    @ApiModelProperty("社区信息列表")
    private GaoDeNeighborhoodVo neighborhood;

    @ApiModelProperty("楼信息列表")
    private GaoDeBuildingVo building;

    @ApiModelProperty("门牌信息列表")
    private GaoDeStreetNumberVo streetNumber;

    @ApiModelProperty("经纬度所属商圈列表")
    private List<GaoDeBusinessAreasVo> businessAreas;

}
