package com.biz.crm.common.gaode.sdk.vo.convert;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("逆地理编码列表")
public class GaoDeRegeocodeVo {

    @ApiModelProperty("地址元素列表")
    private GaoDeAddressComponentVo addressComponent;

    //请求参数 extensions 为 all 时返回如下内容
    @ApiModelProperty("道路信息列表")
    private List<GaoDeRoadsVo> roads;

    //请求参数 extensions 为 all 时返回如下内容
    @ApiModelProperty("道路交叉口列表")
    private List<GaoDeRoadintersVo> roadinters;

    //请求参数 extensions 为 all 时返回如下内容
    @ApiModelProperty("poi 信息列表")
    private List<GaoDePoisVo> pois;

    //请求参数 extensions 为 all 时返回如下内容
    @ApiModelProperty("aoi 信息列表")
    private List<GaoDeAoisVo> aois;

    //例如：北京市朝阳区望京街道方恒国际中心B座
    @ApiModelProperty("完整地址")
    private String formatted_address;

}
