package com.biz.crm.business.common.identity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 承载经销商游客的登录信息</p>
 * @author pengxi
 */
@Getter
@Setter
public class DistributorVisitorDetails extends DistributorUserDetails {
  private static final long serialVersionUID = -6785761636962732932L;
  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String phone;

  @Override
  public String getPostCode() {
    // 经销商从业务上来说，是没有岗位的
    return "customer_visitor";
  }

  @Override
  public String getPostName() {
    // 经销商从业务上来说，是没有岗位的
    return "游客";
  }

}
