package com.biz.crm.business.common.identity;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * @author jerry7 yinwenjie
 * @date 2021/8/4 11:11
 * CRM-厂商用户登录信息实体类，实现springframework.security的UserDetails接口，用于获取数据用户登录信息</br>
 * 并由yinwenjie，在2021年-08-15做出设计变化
 */
@Getter
@Setter
public class FacturerUserDetails extends AbstractCrmUserIdentity {
    private static final long serialVersionUID = -8793810512026511424L;

    @ApiModelProperty("可能的电话信息")
    private String phone;

    @ApiModelProperty("岗位ID")
    private String postId;

    @ApiModelProperty("岗位编码")
    private String postCode;

    @ApiModelProperty("岗位名称")
    private String postName;

    @ApiModelProperty("组织ID")
    private String orgId;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("语言")
    private String language;

    @ApiModelProperty("来源类型")
    private String fromType;

    @ApiModelProperty("openid 微信openid 或者支付宝 用户id")
    private String openId;

    @ApiModelProperty("openCode 微信openCode")
    private String openCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("当前用户所有岗位编码集合")
    private Set<String> postCodes;

    @ApiModelProperty("IDM票据")
    private String ticketValue;
}
