package com.biz.crm.business.common.transform;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.transform.IdentityTransformStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * CRM系统厂商管理平台（MDM+DMS+CPS+SFA+TPM）boot，在收到携带了JWT信息的请求后，如果发现源信息中用户身份标识sourceIdentityType为u，则通过JSON信息自行转换
 *
 * @author yinwenjie
 */
@Component
public class FacturerToFacturerTransformStrategy implements IdentityTransformStrategy {
    /**
     * 日志
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(FacturerToFacturerTransformStrategy.class);

    @Override
    public boolean matched(String sourceIdentityType) {
        // u-企业用户，c-客户用户，terminal-终端用户，customer_employee-经销商员工用户</br>
        return true;
    }

    @Override
    public UserIdentity transform(String sourceIdentityType, String sourceTenantCode, String sourceAccount, JSONObject userObject) {
        LOGGER.info("========= FacturerToFacturerTransformStrategy transform : " + sourceIdentityType + "  " + sourceAccount);
        // 转换成厂商用户自身
        return JSONObject.toJavaObject(userObject, FacturerUserDetails.class);
    }

    @Override
    public int getOrder() {
        // 默认转换策略，最后一个执行
        return Integer.MAX_VALUE;
    }

}
