package com.biz.crm.common.ie.local.concurrent.threadpool;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import cn.hutool.core.thread.RejectPolicy;
import lombok.extern.slf4j.Slf4j;

/**
 * Crm线程池，使用自定义阻塞队列
 * 
 * @author Ken.xu
 *
 */
@Slf4j
public class CrmThreadPoolExecutorFactory {
  public static volatile Map<String, ThreadPoolExecutor> threadPoolMap = new ConcurrentHashMap<>(10);

  private CrmThreadPoolExecutorFactory() {}

  /**
   * 获取默认线程池
   * 
   * @return
   */
  public static ThreadPoolExecutor instance(CrmThreadPoolParam poolParam, ThreadFactory threadFactory) {
    ThreadPoolExecutor instance = instance(poolParam, threadFactory, "CrmThreadPool");
    return instance;
  }

  /**
   * 获取一个单例的线程池
   * 
   * @param threadGroupName
   * @return
   */
  public static ThreadPoolExecutor instance(CrmThreadPoolParam poolParam, ThreadFactory threadFactory,
      String threadGroupName) {
    ThreadPoolExecutor instance = null;
    if ((instance = threadPoolMap.get(threadGroupName)) != null) {
      return instance;
    }
    synchronized (threadPoolMap) {
      // double check
      if ((instance = threadPoolMap.get(threadGroupName)) != null) {
        return instance;
      }
      log.info("The thread pool instance is empty, so need to create. ThreadGroupName=" + threadGroupName);
      BlockingQueue<Runnable> blockingQueue;
      if (poolParam.rejectPolicy.getClass() == RejectPolicy.BLOCK.getValue().getClass()) {
        log.info("使用阻塞队列");
        blockingQueue = new ArrayBlockingQueue<>(poolParam.queueCapacity);
      } else {
        log.info("使用无界队列");
        blockingQueue = new LinkedBlockingQueue<>(poolParam.queueCapacity);
      }
      instance = new ThreadPoolExecutor(
          poolParam.corePoolSite,
          poolParam.maxPoolSite,
          poolParam.keepAliveTime,
          TimeUnit.SECONDS,
          blockingQueue,
          threadFactory,
          poolParam.rejectPolicy);
      log.info("The thread pool instance info: " + instance);
      threadPoolMap.put(threadGroupName, instance);
    }
    return instance;
  }
}
