package com.biz.crm.common.ie.local.config;

import com.biz.crm.common.ie.local.service.strategy.DefaultExcelProcessStrategyImpl;
import com.biz.crm.common.ie.local.service.task.ImportExportThreadPoolExecutor;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 导入导出config
 *
 * @author sunx
 * @date 2022/5/10
 */
@Configuration
@EntityScan(basePackages = "com.biz.crm.common.ie.local.entity")
@EnableConfigurationProperties(ImportExportProperties.class)
public class ImportExportConfig {

  private final ImportExportProperties importExportProperties;

  public ImportExportConfig(ImportExportProperties importExportProperties) {
    this.importExportProperties = importExportProperties;
  }

  @Bean("_importExportThreadPoolExecutor")
  public ImportExportThreadPoolExecutor ieThreadPoolExecutor() {
    ImportExportThreadPoolExecutor importExportThreadPoolExecutor = new ImportExportThreadPoolExecutor();
    importExportThreadPoolExecutor.setImportTaskCount(this.importExportProperties.getImportProperties().getTaskCount());
    importExportThreadPoolExecutor.setExportTaskCount(this.importExportProperties.getExportProperties().getTaskCount());
    importExportThreadPoolExecutor.setExportGetTotalTaskCount(this.importExportProperties.getExportAsyncGetDataProperties().getTaskCount());
    importExportThreadPoolExecutor.setExportEsParagraphTaskCount(this.importExportProperties.getExportEsParagraphProperties().getTaskCount());
    return importExportThreadPoolExecutor;
  }

  @Bean
  public CrmExcelProcessStrategy crmExcelProcessStrategy() {
    return new DefaultExcelProcessStrategyImpl();
  }
}
