package com.biz.crm.common.ie.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.sdk.dto.ExportFieldDto;
import com.biz.crm.common.ie.sdk.service.ExportFieldVoService;
import com.biz.crm.common.ie.sdk.vo.ExportFieldVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 导出任务: ExportTask: 导出字段
 * @createTime 2023年07月25日 14:22:00
 */
@Slf4j
@Api(tags = "导出任务: ExportField: 导出字段")
@RestController
@RequestMapping(value = {"/v1/exportTask/exportTaskField"})
public class ExportFieldController {


  @Autowired
  private ExportFieldVoService exportFieldService;

  /**
   * 根据菜单编码获取字段集合
   *
   * @param menuCode 菜单编码
   * @return
   */
  @ApiOperation(value = "根据任务编码获取详情")
  @GetMapping(value = {"/findByMenuCode"})
  public Result<List<ExportFieldVo>> findDetailByTaskCode(@RequestParam("menuCode") String menuCode) {
    try {
      List<ExportFieldVo> res = exportFieldService.findByMenuCode(menuCode);
      return Result.ok(res);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 保存字段集合
   *
   * @param exportField 保存字段集合
   * @return
   */
  @ApiOperation(value = "保存字段集合")
  @PostMapping(value = "")
  public Result create(@RequestBody List<ExportFieldDto> exportField) {
    try {
       exportFieldService.save(exportField);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
