package com.biz.crm.common.ie.local.controller;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.Enumeration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.bean.ExportTaskExtendsVo;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.model.vo.ExportProcessItemModelVo;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.sdk.dto.CreateExportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.bizunited.nebula.common.config.NebulaToolkitConfig;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Lists;
import cn.hutool.core.bean.BeanUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 导出任务: ImportTask: 导出任务
 *
 * @author sunx
 * @date 2022-05-18 16:31:06
 */
@Slf4j
@Api(tags = "导出任务: ExportTask: 导出任务")
@RestController
@RequestMapping(value = {"/v1/exportTask/exportTask"})
public class ExportTaskController {
  @Autowired(required = false)
  private ExportTaskService exportTaskService;
  @Autowired(required = false)
  private List<ExportProcess<CrmExcelVo>> exportProcesses;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private RedisMutexService redisMutexService;
  @Autowired
  private LoginUserService loginUserService;
  /**
   * 查询分页列表
   *
   * @param pageable 分页
   * @param paginationDto 查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ExportTask>> findByConditions(@PageableDefault(50) Pageable pageable,
      ExportTaskPaginationDto paginationDto) {
    try {
      Page<ExportTask> result = this.exportTaskService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 导出文件管理-取消导出任务
   *
   * @param codes
   */
  @ApiOperation(value = "导出文件管理-取消导出任务")
  @PostMapping("/cancelTask")
  public Result cancelTask(@RequestBody List<String> codes) {
    try {
      this.exportTaskService.cancelTask(codes);
      return Result.ok("执行成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据任务编码获取详情
   *
   * @param taskCode 任务编码
   * @return
   */
  @ApiOperation(value = "根据任务编码获取详情")
  @GetMapping(value = {"/findDetailByTaskCode"})
  public Result<ExportTask> findDetailByTaskCode(@RequestParam("taskCode") String taskCode) {
    try {
      ExportTask exportTask = this.exportTaskService.findDetailByTaskCode(taskCode);
      return Result.ok(exportTask);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取导出业务注册器主要信息
   *
   * @return
   */
  @ApiOperation(value = "获取导出业务注册器主要信息")
  @GetMapping(value = "/findAllExportBusiness")
  public Result<List<ExportProcessItemModelVo>> findAllExportBusiness() {
    List<ExportProcessItemModelVo> list = Lists.newLinkedList();
    if (CollectionUtils.isEmpty(exportProcesses)) {
      return Result.ok(list);
    }
    for (ExportProcess<CrmExcelVo> item : exportProcesses) {
      final ExportProcessItemModelVo cur = new ExportProcessItemModelVo();
      cur.setBusinessCode(item.getBusinessCode());
      cur.setBusinessName(item.getBusinessName());
      list.add(cur);
    }
    return Result.ok(list);
  }


  /**
   * 新建导出任务
   *
   * @param dto 任务实体
   * @return
   */
  @ApiOperation(value = "新建导出任务")
  @PostMapping(value = "")
  public Result<ExportTaskExtendsVo> create(HttpServletRequest request, @RequestBody CreateExportTaskDto dto) {
    MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
    String listCode = marsAuthorityContext.getListCode();
    dto.setMarsListCode(listCode);
    String lockKey = String.format("%s:%s:%s:%s:%s", ImportExportConstant.IE_EXPORT_CREATE_REDIS_LOCK_KEY
        , dto.getParentCode(), dto.getFunctionCode(), dto.getBusinessCode(), this.loginUserService.findCurrentAccount());
    boolean locked = false;
    try {
      locked = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 5);
      Validate.isTrue(locked, "导出任务操作频繁,请稍后再试！");
      // 过滤空值，减少无用参数
      dto.getParams().entrySet()
          .removeIf(entry -> entry.getValue() == null || StringUtils.isBlank("" + entry.getValue()));
      ExportTask current = this.exportTaskService.create(dto);
      // 查询当前任务前是否有待执行任务
      int count = this.exportTaskService.getTaskCountByNoExe(current);
      ExportTaskExtendsVo obj =
          nebulaToolkitService.copyObjectByBlankList(current, ExportTaskExtendsVo.class,
              HashSet.class, ArrayList.class);
      obj.setToBeExecutedTaskNum(count);
      return Result.ok(obj);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      if (locked) {
        redisMutexService.unlock(lockKey);
      }
    }
  }
}
