package com.biz.crm.common.ie.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.service.ExportTaskDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 导入子任务: ExportTaskDetail: 导入子任务
 *
 * @author sunx
 * @date 2022-05-12 09:25:18
 */
@Slf4j
@Api(tags = "导入子任务: ExportTaskDetail: 导入子任务")
@RestController
@RequestMapping(value = {"/v1/importTask/importTaskDetail"})
public class ExportTaskDetailController {

  @Autowired private ExportTaskDetailService exportTaskDetailService;

  /**
   * 根据子任务编码获取详情
   *
   * @param detailCode 子任务编码
   * @return
   */
  @ApiOperation(value = "根据子任务编码获取详情")
  @GetMapping(value = {"/findDetailByDetailCode"})
  public Result<ExportTaskDetail> findDetailByDetailCode(
      @RequestParam("detailCode") String detailCode) {
    try {
      ExportTaskDetail exportTaskDetail =
          this.exportTaskDetailService.findDetailByDetailCode(detailCode);
      return Result.ok(exportTaskDetail);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
