package com.biz.crm.common.ie.local.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.bean.IeTaskCodeInfoVo;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 任务文件查询
 */
@Slf4j
@Api(tags = "任务文件查询")
@RestController
@RequestMapping(value = {"/v1/ieTask/ieTask"})
public class IeTaskController {
  @Autowired(required = false)
  private FileHandleService fileHandleService;
  @Autowired(required = false)
  private ExportTaskService exportTaskService;
  @Autowired
  private ImportTaskService importTaskService;

  /**
   * 任务文件查询
   *
   * @param taskInfo 任务编码
   */
  @ApiOperation(value = "任务文件查询")
  @PostMapping("/getFileInfo")
  public Result getFileInfo(@RequestBody List<IeTaskCodeInfoVo> taskInfo) {
    try {
      List<String> importTaskInfo = new ArrayList<>();
      List<String> exportTaskInfo = new ArrayList<>();
      // 01。务进行拆分
      for (IeTaskCodeInfoVo row : taskInfo) {
        String taskType = row.getIeType();
        if (taskType == null) {
          log.warn("前端传入参数异常，无type【imp/exp】：{}", row);
        }
        if (TypeEnum.IMPORT.getDictCode().equals(taskType)) {
          importTaskInfo.add(row.getTaskCode());
        } else if (TypeEnum.EXPORT.getDictCode().equals(taskType)) {
          exportTaskInfo.add(row.getTaskCode());
        } else {
          log.warn("前端传入参数异常，type非【imp/exp】：{}", taskType);
        }
      }
      // 02. 分别查询导入导出
      Map<String, String> fileNameMap = Maps.newHashMap();
      // 02.01 查询导入
      for (String taskCode : exportTaskInfo) {
        ExportTask task = exportTaskService.findExportTask(taskCode);
        if (task != null) {
          String fileName = task.getFileName();
          fileNameMap.put(taskCode, fileName);
        } else {
          log.info("导出任务无法查询到{}", taskCode);
        }
      }
      // 02.01 查询导出
      for (String taskCode : importTaskInfo) {
        ImportTask task = importTaskService.findDetailByTaskCode(taskCode);
        if (task != null) {
          String fileName = task.getFile().getFileName();
          fileNameMap.put(taskCode, fileName);
        } else {
          log.info("导入任务无法查询到{}", taskCode);
        }
      }
      // String[] ids = {};
      // List<OrdinaryFileVo> findListByIds = fileHandleService.findListByIds(ids);
      return Result.ok(fileNameMap);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
