package com.biz.crm.common.ie.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.local.model.vo.ImportTreeModelVo;
import com.biz.crm.common.ie.local.service.ImportTemplateService;
import com.biz.crm.common.ie.sdk.dto.ImportTemplatePaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 导入模板: ImportTemplate: 导入模板
 *
 * @author sunx
 * @date 2022-05-10 10:27:59
 */
@Slf4j
@Api(tags = "导入模板: ImportTemplate: 导入模板")
@RestController
@RequestMapping(value = {"/v1/importTemplate/importTemplate"})
public class ImportTemplateController {

    @Autowired
    private ImportTemplateService importTemplateService;

    /**
     * 查询分页列表
     *
     * @param pageable      分页
     * @param paginationDto 查询参数
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<ImportTemplate>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         ImportTemplatePaginationDto paginationDto) {
        try {
            Page<ImportTemplate> result = this.importTemplateService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据业务编码获取详情
     *
     * @param businessCode 业务编码
     * @return
     */
    @ApiOperation(value = "根据业务编码获取详情")
    @GetMapping(value = {"/findDetailByBusinessCode"})
    public Result<ImportTemplate> findDetailByBusinessCode(@RequestParam("businessCode") String businessCode) {
        try {
            ImportTemplate importTemplate =
                    this.importTemplateService.findDetailByBusinessCode(businessCode);
            return Result.ok(importTemplate);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取模板管理业务-模板下拉树
     *
     * @return
     */
    @ApiOperation(value = "获取模板管理业务-模板下拉树")
    @GetMapping(value = "/findTemplateTree")
    public Result<List<ImportTreeModelVo>> findTemplateTree() {
        try {
            List<ImportTreeModelVo> list = this.importTemplateService.findTemplateTree();
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据业务编码获取下级模板下拉
     *
     * @return
     */
    @ApiOperation(value = "根据业务编码获取下级模板下拉")
    @GetMapping(value = "/findTemplateSelectByBusinessCode")
    public Result<List<ImportTreeModelVo>> findTemplateSelectByBusinessCode(@RequestParam("businessCode") String businessCode) {
        try {
            List<ImportTreeModelVo> list =
                    this.importTemplateService.findTemplateSelectByBusinessCode(businessCode);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param importTemplate 导入模板实体
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ImportTemplate> create(@RequestBody ImportTemplate importTemplate) {
        try {
            ImportTemplate current = this.importTemplateService.create(importTemplate);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param importTemplate 导入模板实体
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<ImportTemplate> update(@RequestBody ImportTemplate importTemplate) {
        try {
            ImportTemplate current = this.importTemplateService.update(importTemplate);
            return Result.ok(current);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据业务编码集合删除
     *
     * @param businessCodes 业务编码集合
     * @return
     */
    @ApiOperation(value = "根据业务编码集合删除")
    @DeleteMapping("/deleteByBusinessCodes")
    public Result deleteByBusinessCodes(@RequestParam("businessCodes") List<String> businessCodes) {
        try {
            this.importTemplateService.deleteByBusinessCodes(businessCodes);
            return Result.ok("删除成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
