package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.List;

/**
 * 导入模板主表(ImportTemplate)实体类
 *
 * @author sunx
 * @since 2022-05-10 10:27:58
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_import_template")
@Table(
        name = "ie_import_template",
        indexes = {
                @Index(name = "ie_i_t_idx1", columnList = "business_code", unique = true),
        })
@ApiModel(value = "ImportTemplate", description = "导入模板主表")
@org.hibernate.annotations.Table(appliesTo = "ie_import_template", comment = "导入模板主表")
public class ImportTemplate extends TenantFlagOpEntity {
    private static final long serialVersionUID = -4205727783720188958L;

    /**
     * 导入业务编码
     */
    @ApiModelProperty("导入业务编码")
    @TableField(value = "business_code")
    @Column(name = "business_code", length = 64, columnDefinition = "VARCHAR2(64) ")
    private String businessCode;

    /**
     * 导入业务名称
     */
    @ApiModelProperty("导入业务名称")
    @TableField(value = "business_name")
    @Column(name = "business_name", length = 64, columnDefinition = "VARCHAR2(64)")
    private String businessName;

    /**
     * 模板信息
     */
    @ApiModelProperty("模板信息")
    @Transient
    @TableField(exist = false)
    private List<ImportTemplateDetail> list;

    /**
     * springboot应用程序名
     */
    @ApiModelProperty("springboot应用程序名")
    @TableField(value = "application_name")
    @Column(
            name = "application_name",
            length = 64,
            columnDefinition = "VARCHAR2(64) ")
    private String applicationName;
}
