package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.local.mapper.ImportTemplateMapper;
import com.biz.crm.common.ie.sdk.dto.ImportTemplatePaginationDto;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 导入模板主表(repository)
 *
 * @author sunx
 * @date 2022-05-10 10:27:58
 */
@Component
public class ImportTemplateRepository extends ServiceImpl<ImportTemplateMapper, ImportTemplate> {

    /**
     * 分页
     *
     * @param page 分页
     * @param dto  查询参数
     * @return
     */
    public Page<ImportTemplate> findByConditions(Page<ImportTemplate> page, ImportTemplatePaginationDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    /**
     * 根据id查询详情
     *
     * @param id 主键
     * @return
     */
    public ImportTemplate findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据业务编码集合删除
     *
     * @param businessCodes 业务编码集合
     */
    public void deleteByBusinessCodes(List<String> businessCodes) {
        LambdaQueryWrapper<ImportTemplate> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(ImportTemplate::getBusinessCode, businessCodes);
        this.baseMapper.delete(lambdaQuery);
    }

    /**
     * 根据业务编码获取对应的信息
     *
     * @param businessCode 业务编码
     * @return
     */
    public ImportTemplate findByBusinessCode(String businessCode) {
        return this.lambdaQuery().eq(ImportTemplate::getBusinessCode, businessCode).one();
    }

    /**
     * 获取应用已维护业务信息
     *
     * @param appName 应用名称
     * @return
     */
    public List<ImportTemplate> findByAppName(String appName) {
        return this.lambdaQuery().eq(ImportTemplate::getApplicationName, appName).list();
    }
}
