package com.biz.crm.common.ie.local.service;

import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.model.dto.ExportTaskDetailModelDto;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.EsParagraphFieldRangeVo;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 导出任务子任务(ExportTaskDetail)表服务接口
 *
 * @author sunx
 * @date 2022-05-18 16:31:07
 */
public interface ExportTaskDetailService {

  /**
   * 根据任务编码获取子任务信息
   *
   * @param taskCodeSet 任务编码集合
   * @return
   */
  List<ExportTaskDetail> findByTaskCodes(Set<String> taskCodeSet);

  /**
   * 新增子任务
   *
   * @param list 导出任务明细
   * @param taskCode 主任务编码
   * @return
   */
  void create(List<ExportTaskDetail> list, String taskCode);

  /**
   * 根据ExportTaskDetailModelDto获取任务信息(主要用于加载任务)
   *
   * @param dto 导出任务明细model实体
   * @return
   */
  List<ExportTaskDetail> findByExportTaskDetailModelDto(ExportTaskDetailModelDto dto);

  /**
   * 更新子任务加载状态
   *
   * @param detailCodeSet 子任务编码集合
   * @param loadStatus 加载状态
   */
  void updateLocalStatus(Set<String> detailCodeSet, String loadStatus);

  /**
   * 根据子任务编码获取子任务信息(为导入逻辑使用，不包含文件信息)
   *
   * @param detailCode 子任务编码集合
   * @return
   */
  ExportTaskDetail findByDetailCode(String detailCode);

  /**
   * 根据子任务编码获取子任务信息(包含文件信息)
   *
   * @param detailCode 子任务编码集合
   * @return
   */
  ExportTaskDetail findDetailByDetailCode(String detailCode);

  /**
   * 保存主任务信息，并根据主题任务信息，创建任务明细
   * @param exportTask
   * @return 导出任务明细
   */
  List<ExportTaskDetail> saveExportTaskAndCreateExportTaskDetail(ExportTask exportTask);

  /**
   * 构建导出参数映射
   *
   * @param exportTask 导出任务
   * @param exportProcess 导出实现类
   * @return 导出参数映射
   */
  Map<String, Object> buildExportParamMap(ExportTask exportTask, ExportProcess<?> exportProcess);

  /**
   * 执行导出子任务ES数据分段
   *
   * @param exportTask 导出任务
   * @param exportTaskDetail 导出子任务
   * @param startFieldRanges 起始分段信息
   * @return 最后一个分段信息
   */
  List<EsParagraphFieldRangeVo> execExportTaskDetailEsParagraph(ExportTask exportTask
      , ExportTaskDetail exportTaskDetail, List<EsParagraphFieldRangeVo> startFieldRanges);
}
