package com.biz.crm.common.ie.local.service.spring;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Map;

/**
 * @author Kevin
 * @title SpringControllerApiService
 * @date 2023/10/8 15:12
 * @description controller api处理接口
 */
public interface SpringControllerApiService {

  /**
   * 获取分页记录数
   * @param url 调用的url地址
   * @param requestMapping 请求类型（GET POST）
   * @param requestParamJson 请求参数
   * @return
   */
  Long getPageTotal(String url,String requestMapping,String requestParamJson);

  /**
   * 返回page对象
   * @param url 调用的url地址
   * @param requestMapping 请求类型
   * @param requestParamJson  请求参数 (参数中的 page pageNum 需要根据页码进行+1操作)
   * @param pageNum 分页参数
   * @param pageSize 分页大小
   * @return
   */
  IPage<?> getPage(String url,String requestMapping,String requestParamJson,int pageNum ,int pageSize);

  /**
   * 执行方法
   * @param url 调用的url地址
   * @param requestMapping 请求类型
   * @param requestParamMap 请求参数集
   * @return
   */
  Object doInvoke(String url,String requestMapping, Map<String,Object> requestParamMap);
}
