package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IRequestParamParse;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

/**
 * @title RequestParamParseForBigDecimal
 * @date 2023/10/10 10:20
 * @author Kevin
 * @description BigDecimal 数据类型
 */
@Component
public class RequestParamParseForBigDecimal implements IRequestParamParse<BigDecimal> {

  @Override
  public boolean isApplicable(Class<?> parameterType) {
    return parameterType == BigDecimal.class;
  }

  @Override
  public BigDecimal getValue(String defaultValueString) throws IllegalArgumentException {
    return new BigDecimal(defaultValueString);
  }
}
