package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IRequestParamParse;
import org.springframework.stereotype.Component;

/**
 * @title RequestParamParseForLong
 * @date 2023/10/10 10:29
 * @author Kevin
 * @description Long类型
 */
@Component
public class RequestParamParseForLong implements IRequestParamParse<Long> {

  @Override
  public boolean isApplicable(Class<?> parameterType) {
    return parameterType == Long.TYPE;
  }

  @Override
  public Long getValue(String defaultValueString) throws IllegalArgumentException {
    return new Long(defaultValueString);
  }
}
