package com.biz.crm.common.ie.local.service.task;

import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.local.service.task.cache.ExportTaskCache;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.config.ImportExportProperties.ExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.service.ExportTaskDetailService;
import com.biz.crm.common.ie.local.service.task.tools.TaskExecutorAuthTool;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExportGetTotal;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import java.util.List;
import cn.hutool.core.thread.ThreadUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * 导出任务拆子任务
 *
 * @author Ken.xu
 * @date 2023-9-14 16:12:59
 */
@Component("_IeTaskExecutorForExportGetTotal")
@Scope("prototype")
@Lazy
@Slf4j
public class IeTaskExecutorForExportGetTotal implements Runnable {
  /** 导入任务执行前置参数 */
  @Getter
  private IeExecutorVoForExportGetTotal vo;
  private ExportTask exportTask;
  /** 当前租户信息 */
  private AbstractTenantInfo tenantInfo;
  // =====================
  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired(required = false)
  private ExportTaskService exportTaskService;
  @Autowired
  private ImportExportProperties importExportProperties;
  @Autowired
  private ExportTaskCache exportTaskCache;

  public IeTaskExecutorForExportGetTotal(IeExecutorVoForExportGetTotal vo, ExportTask exportTask, AbstractTenantInfo tenantInfo) {
    this.vo = vo;
    this.exportTask = exportTask;
    this.tenantInfo = tenantInfo;
  }

  @Override
  public void run() {
    // 异步线程还原租户信息，切换数据源
    TenantContextHolder.setTenantInfo(tenantInfo);
    Integer defaultLoginType = simpleSecurityProperties.getDefaultLoginType();
    try {
      // 重建用户权限环境
      TaskExecutorAuthTool.refreshUseAuthAndTenantCode(loginUserService, vo, defaultLoginType);
      this.exportTaskService.execExportGetTotal(exportTask);
      log.debug("总记录数{}，拆分任务{}", exportTask.getTotal(), exportTask.getList().size());
    } catch (Exception e) {
      log.error("执行导出操作异常：", e);
      this.exportTaskService.updateExecStatusContainsDetail(ExecStatusEnum.FAILED, Sets.newHashSet(exportTask.getTaskCode()));
    } finally {
      // 不管是否执行成功都需要将缓存清除掉
      this.exportTaskCache.removeExecAsyncGetTotalTask(exportTask.getAppCode(), exportTask.getApplicationName(), exportTask.getTaskCode());
    }
    log.debug("******导出任务执完成*********");
    long taskExecutionAfterSleep = importExportProperties.getTaskExecutionIntervalSleep();
    if (taskExecutionAfterSleep > 0) {
      ThreadUtil.sleep(taskExecutionAfterSleep);
      log.debug("******休眠释放数据库时间分片*********");
    }
  }

}
