/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.bean;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ImportProcessEnum;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.biz.crm.common.ie.sdk.vo.ImportProcessMsgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ImportSendProcessMsgBean {
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private ChannelMsgService channelMsgService;
    @Autowired
    private LoginUserService loginUserService;
    private static final String IE_IMPORT_MODEL_CODE = "ie_import_model";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportSendProcessMsgBean.class);

    public void sendProcessMsg(String taskCode, ImportProcessEnum processEnum, String account) {
        this.sendProcessMsg(taskCode, processEnum, ExecStatusEnum.RUNNING, account);
    }

    public void sendProcessMsg(String taskCode, ImportProcessEnum processEnum, ExecStatusEnum execStatusEnum, String account) {
        this.sendProcessMsg(taskCode, processEnum, execStatusEnum.getDictCode(), processEnum.getDesc(), account);
    }

    public void sendProcessMsg(String taskCode, ImportProcessEnum processEnum, String execStatus, String remark, String account) {
        ImportProcessMsgVo vo = new ImportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setIeType(TypeEnum.IMPORT.getDictCode());
        vo.setExecStatus(execStatus);
        vo.setProcessType(processEnum.getCode());
        vo.setRemark(remark);
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendProcessMsg(vo);
    }

    public void sendProcessMsg(String taskCode, ImportProcessEnum processEnum, String execStatus, String remark, String account, ImportTask importTask) {
        ImportProcessMsgVo vo = new ImportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setIeType(TypeEnum.IMPORT.getDictCode());
        vo.setExecStatus(execStatus);
        vo.setProcessType(processEnum.getCode());
        vo.setRemark(remark);
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        vo.setFileCode(importTask.getFailedFileCode());
        this.sendProcessMsg(vo);
    }

    public void sendProcessMsg(String taskCode, Integer total, Integer cursor, Integer successNum, Integer failedNum, String account) {
        ImportProcessMsgVo vo = new ImportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setIeType(TypeEnum.IMPORT.getDictCode());
        vo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        vo.setProcessType(ImportProcessEnum.RUNNING.getCode());
        vo.setPageSize(total);
        vo.setCursor(cursor);
        vo.setRemark(CharSequenceUtil.format((CharSequence)ImportProcessEnum.RUNNING.getFormat(), (Object[])new Object[]{total, cursor, successNum, failedNum}));
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendProcessMsg(vo);
    }

    public void sendProcessMsg(String taskCode, Integer successNum, Integer failedNum, Integer total, String account) {
        ImportProcessMsgVo vo = new ImportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setIeType(TypeEnum.IMPORT.getDictCode());
        vo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        vo.setProcessType(ImportProcessEnum.END_EXEC.getCode());
        vo.setRemark(CharSequenceUtil.format((CharSequence)ImportProcessEnum.END_EXEC.getFormat(), (Object[])new Object[]{total, successNum, failedNum}));
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendProcessMsg(vo);
    }

    public void sendProcessMsg(String taskCode, Integer total, Integer cursor, Integer current, Integer successNum, Integer failedNum, String account, ImportProcessEnum process) {
        ImportProcessMsgVo vo = new ImportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setIeType(TypeEnum.IMPORT.getDictCode());
        vo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        vo.setProcessType(process.getCode());
        vo.setPageSize(total);
        vo.setCursor(current);
        vo.setRemark(CharSequenceUtil.format((CharSequence)process.getFormat(), (Object[])new Object[]{total, cursor, successNum, failedNum}));
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendProcessMsg(vo);
    }

    public void sendFailedProcessMsg(String taskCode, String msg, String account) {
        ImportProcessMsgVo vo = new ImportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setIeType(TypeEnum.IMPORT.getDictCode());
        vo.setExecStatus(ExecStatusEnum.FAILED.getDictCode());
        vo.setProcessType(ImportProcessEnum.END.getCode());
        vo.setRemark(msg);
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendProcessMsg(vo);
    }

    private void sendProcessMsg(ImportProcessMsgVo vo) {
        vo.setTime(new Date());
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)vo, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String ieChannelTaskCode = "CRM_ALL";
        String exportAndImportModelCode = "ie_export_import_model";
        LOGGER.info(" import model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, this.applicationName, IE_IMPORT_MODEL_CODE});
        LOGGER.info(" import model send msg2: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, ieChannelTaskCode, exportAndImportModelCode});
        if (StringUtils.isNotBlank((CharSequence)vo.getAccount())) {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, IE_IMPORT_MODEL_CODE, vo.getAccount(), jsonBytes);
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, ieChannelTaskCode, exportAndImportModelCode, vo.getAccount(), jsonBytes);
        } else {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, this.applicationName, IE_IMPORT_MODEL_CODE, jsonBytes);
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, ieChannelTaskCode, exportAndImportModelCode, jsonBytes);
        }
    }

    public void sendMsgByAll(ImportProcessMsgVo vo) {
        vo.setTime(new Date());
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)vo, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String ieChannelTaskCode = "CRM_ALL";
        String exportAndImportModelCode = "ie_export_import_model";
        LOGGER.info(" import model send msg2: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, ieChannelTaskCode, exportAndImportModelCode});
        if (StringUtils.isNotBlank((CharSequence)vo.getAccount())) {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, ieChannelTaskCode, exportAndImportModelCode, vo.getAccount(), jsonBytes);
        } else {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, ieChannelTaskCode, exportAndImportModelCode, jsonBytes);
        }
    }
}

