/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.sdk.vo.ImportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.WebsocketServerModelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ie/websocket"})
public class WebsocketController {
    private static final Logger log = LoggerFactory.getLogger(WebsocketController.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private ChannelMsgService channelMsgService;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final String IE_IMPORT_MODEL_CODE = "ie_import_model";

    @ApiOperation(value="\u83b7\u53d6\u53ef\u7528websocket\u670d\u52a1")
    @GetMapping(value={"/findServer"})
    public Result<WebsocketServerModelVo> findServer() {
        try {
            Object o = this.redisTemplate.opsForValue().get((Object)CharSequenceUtil.format((CharSequence)"bz:crm:ie:{}:host", (Object[])new Object[]{this.importExportProperties.getIeTaskGroup()}));
            Validate.notNull((Object)o, (String)"\u672a\u83b7\u53d6\u5230websocket\u670d\u52a1\u4fe1\u606f", (Object[])new Object[0]);
            WebsocketServerModelVo vo = new WebsocketServerModelVo();
            vo.setServer(CharSequenceUtil.format((CharSequence)"ws://{}/ie/ws/ie", (Object[])new Object[]{o.toString()}));
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/sendImportProcessMsg"})
    public Result<?> sendImportProcessMsg(@RequestBody ImportProcessMsgVo vo) {
        try {
            byte[] jsonBytes = JSONObject.toJSONBytes((Object)vo, (SerializerFeature[])new SerializerFeature[0]);
            String tenantCode = TenantUtils.getTenantCode();
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, this.applicationName, IE_IMPORT_MODEL_CODE, jsonBytes);
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u51fa\u9519\u4e86{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }
}

