/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.mapper.ExportTaskDetailMapper;
import com.biz.crm.common.ie.local.model.dto.ExportTaskDetailModelDto;
import com.biz.crm.common.ie.local.model.vo.ExportTaskDetailUpdateModelVo;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.configuration.MultiDataSourceProperties;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportTaskDetailRepository
extends ServiceImpl<ExportTaskDetailMapper, ExportTaskDetail> {
    @Autowired
    private MultiDataSourceProperties multiDataSourceProperties;

    public List<ExportTaskDetail> findByTaskCodes(Set<String> taskCodeSet) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ExportTaskDetail::getTaskCode, taskCodeSet)).orderByAsc((Object[])new SFunction[]{ExportTaskDetail::getTaskCode, ExportTaskDetail::getPageNo})).list();
    }

    public void deleteByTaskCode(String taskCode) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(ExportTaskDetail::getTaskCode, new Object[]{taskCode});
        ((ExportTaskDetailMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public List<ExportTaskDetail> findByExportTaskDetailModelDto(ExportTaskDetailModelDto dto) {
        return ((ExportTaskDetailMapper)this.baseMapper).findByExportTaskDetailModelDto(dto);
    }

    public void updateLocalStatus(Set<String> detailCodeSet, String loadStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ExportTaskDetail::getDetailCode, detailCodeSet)).set(ExportTaskDetail::getLoadStatus, (Object)loadStatus)).update();
    }

    public void updateExecStatusByTaskCodes(ExecStatusEnum execStatusEnum, Set<String> taskCodes) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ExportTaskDetail::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(ExportTaskDetail::getTaskCode, taskCodes)).set(ExportTaskDetail::getExecStatus, (Object)execStatusEnum.getDictCode())).update();
    }

    public void updateByExportTaskDetailUpdateModelVo(ExportTaskDetailUpdateModelVo vo) {
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getDetailCode())) {
            return;
        }
        ExportTaskDetail detail = this.findByDetailCode(vo.getDetailCode());
        if (StringUtils.isNotBlank((CharSequence)vo.getExecStatus())) {
            detail.setExecStatus(vo.getExecStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getFileCode())) {
            detail.setFileCode(vo.getFileCode());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getRemark())) {
            detail.setRemark(vo.getRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getLoadStatus())) {
            detail.setLoadStatus(vo.getLoadStatus());
        }
        detail.setExecuteDuration(vo.getExecuteDuration());
        this.updateById((Object)detail);
    }

    public ExportTaskDetail findByDetailCode(String detailCode) {
        return (ExportTaskDetail)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ExportTaskDetail::getDetailCode, (Object)detailCode)).one());
    }
}

