/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.MultipartFileUtil;
import com.biz.crm.common.ie.local.bean.ExportSendProcessMsgBean;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.context.ExportTaskContext;
import com.biz.crm.common.ie.local.context.ExportTaskContextHolder;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.model.dto.ExportTaskProcessModelDto;
import com.biz.crm.common.ie.local.model.vo.ExportTaskDetailUpdateModelVo;
import com.biz.crm.common.ie.local.repository.ExportTaskDetailRepository;
import com.biz.crm.common.ie.local.repository.ExportTaskRepository;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.sdk.enums.CallbackStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportDetailProcessEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.event.ExportNotifyEventListener;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.process.AbstractEsParagraphExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.exception.CrmExportException;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.ExportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskDetailVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskEventVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExportProcessServiceImpl
implements ExportProcessService {
    private static final Logger log = LoggerFactory.getLogger(ExportProcessServiceImpl.class);
    @Autowired
    private ExportTaskService exportTaskService;
    @Autowired
    private ExportTaskDetailRepository exportTaskDetailRepository;
    @Autowired(required=false)
    private ExportTaskRepository exportTaskRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private FileHandleService fileHandleService;
    @Autowired
    private ExportSendProcessMsgBean exportSendProcessMsgBean;
    @Autowired
    private CrmExcelProcessStrategy crmExcelProcessStrategy;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ExportNotifyEventListener> notifyEventListeners;
    @Value(value="${spring.application.name:}")
    private String subsystem;
    private static final Integer EXPORT_FILE_UPLOAD = 91;
    private static final Integer TOTAL = 100;
    private static final String ERR_MSG_FORMAT = "{}\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25";
    private static Map<String, ExportProcess<?>> exportProcessCacheMap = Maps.newHashMap();
    private boolean haveAsyncGetTotalProcess = false;

    @Autowired(required=true)
    public void setExportProcesses(List<ExportProcess<?>> exportProcesses) {
        for (ExportProcess<?> exportProcess : exportProcesses) {
            boolean asyncGetTotal = exportProcess.isAsyncGetTotal();
            if (asyncGetTotal) {
                this.haveAsyncGetTotalProcess = true;
                log.info("\u5bfc\u51fa\u57fa\u5ea7{}\uff0c\u5f02\u6b65\u83b7\u53d6\u4efb\u52a1\u603b\u6570", (Object)exportProcess.getBusinessCode());
            }
            exportProcessCacheMap.put(exportProcess.getBusinessCode(), exportProcess);
        }
    }

    public ExportProcess<?> findExportProcess(String businessCode) {
        if (CollectionUtils.isEmpty(exportProcessCacheMap) || StringUtils.isBlank((CharSequence)businessCode)) {
            return null;
        }
        ExportProcess<?> exportProcess = exportProcessCacheMap.get(businessCode);
        return exportProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProcess(IeExecutorVoForExport vo) {
        try {
            this.exportSendProcessMsgBean.sendDetailTaskProcessMsg(vo.getExportTaskDetailCode(), ExecStatusEnum.RUNNING.getDictCode(), ExportDetailProcessEnum.START, vo.getAccount());
            ExportTaskProcessVo task = this.exportTaskPrevHandler(vo.getExportTaskDetailCode());
            MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
            String marsListCode = task.getMarsListCode();
            marsAuthorityContext.setListCode(marsListCode);
            ExportTaskContext taskContext = new ExportTaskContext();
            taskContext.setTaskParamsMap(this.findParamsMap(task));
            taskContext.setTaskProcessVo(task);
            ExportTaskContextHolder.setContext(taskContext);
            if (StringUtils.isNotBlank((CharSequence)task.getMarsListCode())) {
                log.info("========== \u5df2\u8bbe\u5b9a\u6570\u636e\u5bfc\u51fa\u5b50\u4efb\u52a1\u5339\u914d\u7684\u6570\u636e\u6743\u9650\uff1a{}", (Object)task.getMarsListCode());
            } else {
                log.info("========== \u672a\u8bbe\u5b9a\u6570\u636e\u5bfc\u51fa\u5b50\u4efb\u52a1\u5339\u914d\u7684\u6570\u636e\u6743\u9650");
            }
            task.setTaskSource(vo.getTaskSource());
            this.process(vo, task);
            this.exportSendProcessMsgBean.sendDetailTaskProcessMsg(vo.getExportTaskDetailCode(), ExecStatusEnum.FINISH.getDictCode(), ExportDetailProcessEnum.END, vo.getAccount());
        }
        catch (CrmExportException ex) {
            this.handlerDetailTaskFailed(vo.getTaskCode(), vo.getExportTaskDetailCode(), ex.getMessage(), vo.getAccount());
            log.error("\u5bfc\u51fa\u4efb\u52a1{}\u5931\u8d25,err[{}]", (Object)vo.getExportTaskDetailCode(), (Object)Throwables.getStackTraceAsString((Throwable)ex));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException ex) {
            this.handlerDetailTaskFailed(vo.getTaskCode(), vo.getExportTaskDetailCode(), ex.getMessage(), vo.getAccount());
            log.error("\u5bfc\u51fa\u4efb\u52a1{}\u5931\u8d25,err[{}]", (Object)vo.getExportTaskDetailCode(), (Object)Throwables.getStackTraceAsString((Throwable)ex));
        }
        catch (Exception ex) {
            this.handlerDetailTaskFailed(vo.getTaskCode(), vo.getExportTaskDetailCode(), "\u5bfc\u51fa\u5931\u8d25", vo.getAccount());
            log.error("\u5bfc\u51fa\u4efb\u52a1{}\u5931\u8d25,err[{}]", (Object)vo.getExportTaskDetailCode(), (Object)Throwables.getStackTraceAsString((Throwable)ex));
        }
        finally {
            MarsAuthorityContextHolder.clearContext();
            ExportTaskContextHolder.clearContext();
        }
    }

    private void process(IeExecutorVoForExport vo, ExportTaskProcessVo task) throws IllegalArgumentException, CrmExportException {
        boolean isWebApiExport;
        String businessCode = task.getBusinessCode();
        ExportProcess<?> process = this.findExportProcess(businessCode);
        boolean isEuropaExport = "MDM_EUROPA_EXPORT".equalsIgnoreCase(businessCode) || "MDM_EUROPA_EXPORT_ASYNC".equalsIgnoreCase(businessCode);
        boolean bl = isWebApiExport = "EXPORT_WEB_API".equalsIgnoreCase(businessCode) || "EXPORT_WEB_API_ASYNC".equalsIgnoreCase(businessCode);
        if (isEuropaExport) {
            log.debug("\u7cfb\u7edf\u8c03\u7528\u8fdb\u5165\u6570\u636e\u89c6\u56fe\u5904\u7406\u6a21\u5757:{}", (Object)businessCode);
            String parentCode = vo.getParentCode();
            String functionCode = vo.getFunctionCode();
            Validate.isTrue((parentCode != null ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u5bfc\u51fa\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u83b7\u53d6\u5230parentCode", (Object[])new Object[0]);
            Validate.isTrue((functionCode != null ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u5bfc\u51fa\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u83b7\u53d6\u5230functionCode", (Object[])new Object[0]);
            FunctionPermissionVo funPermVo = new FunctionPermissionVo();
            funPermVo.setFunctionCode(functionCode);
            funPermVo.setParentCode(parentCode);
            this.exportSendProcessMsgBean.sendStartProcessMsg(task, ExportDetailProcessEnum.RUNNING, ExportProcessEnum.RUNNING, vo.getAccount());
            this.detailExcelHandlerForEuropa(task, process, funPermVo);
        } else if (isWebApiExport) {
            log.debug("\u7cfb\u7edf\u8c03\u7528\u8fdb\u5165weiApi\u5904\u7406\u6a21\u5757:{}", (Object)businessCode);
            String parentCode = vo.getParentCode();
            String functionCode = vo.getFunctionCode();
            Validate.isTrue((parentCode != null ? 1 : 0) != 0, (String)"webApi\u5bfc\u51fa\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u83b7\u53d6\u5230parentCode", (Object[])new Object[0]);
            Validate.isTrue((functionCode != null ? 1 : 0) != 0, (String)"webApi\u5bfc\u51fa\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u83b7\u53d6\u5230functionCode", (Object[])new Object[0]);
            FunctionPermissionVo functionPermissionVo = new FunctionPermissionVo();
            functionPermissionVo.setFunctionCode(functionCode);
            functionPermissionVo.setParentCode(parentCode);
            this.exportSendProcessMsgBean.sendStartProcessMsg(task, ExportDetailProcessEnum.RUNNING, ExportProcessEnum.RUNNING, vo.getAccount());
            this.detailExcelHandlerForWebApi(task, process, functionPermissionVo);
        } else {
            String parametersJson = task.getParametersJson();
            JSONObject parseObj = JSONUtil.parseObj((String)parametersJson);
            Object excelField = parseObj.get((Object)"excelField");
            Class findCrmExcelVoClass = process.findCrmExcelVoClass();
            CrmExcelExport excelExport = findCrmExcelVoClass.getAnnotation(CrmExcelExport.class);
            Validate.notNull((Object)excelExport, (String)"excel\u5bfc\u5165bean\u672a\u914d\u7f6eCrmExcelExport\u6ce8\u89e3", (Object[])new Object[0]);
            Field[] fields = ReflectUtil.getFields((Class)findCrmExcelVoClass);
            long count = Stream.of(fields).filter(a -> Objects.nonNull(a.getAnnotation(CrmExcelColumn.class))).count();
            Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"excel\u5bfc\u51fabean\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u914d\u7f6eCrmExcelColumn\u6ce8\u89e3", (Object[])new Object[0]);
            if (process instanceof AbstractEsParagraphExportProcess) {
                this.detailExcelHandlerForEsParagraph(task, process);
            } else {
                this.detailExcelHandler(task, process);
            }
        }
        this.mainTaskHandler(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detailExcelHandlerForWebApi(ExportTaskProcessVo task, ExportProcess<?> process, FunctionPermissionVo functionPermissionVo) throws CrmExportException {
        log.debug("\u5f00\u59cb\u5904\u7406webApi\u5bfc\u51fa\u4e1a\u52a1");
        String fileName = this.getTaskFileName(task, process);
        File tmpFile = null;
        String tmpFilePath = null;
        String parentPath = this.findExportParentPath(task);
        File mkdir = FileUtil.mkdir((String)parentPath);
        tmpFile = FileUtil.file((File)mkdir, (String)fileName);
        try {
            tmpFilePath = tmpFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("\u5b50\u4efb\u52a1\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
            Validate.isTrue((boolean)false, (String)("\u5b50\u4efb\u52a1\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u5931\u8d25" + e.getMessage()), (Object[])new Object[0]);
        }
        try {
            Map<String, Object> paramsMap = this.findParamsMap(task);
            if (StringUtils.isNotBlank((CharSequence)task.getMarsListCode())) {
                log.info("========== \u5df2\u8bbe\u5b9a\u6570\u636e\u5bfc\u51fa\u5b50\u4efb\u52a1\u5339\u914d\u7684\u6570\u636e\u6743\u9650\uff1a{}", (Object)task.getMarsListCode());
            } else {
                log.info("========== \u672a\u8bbe\u5b9a\u6570\u636e\u5bfc\u51fa\u5b50\u4efb\u52a1\u5339\u914d\u7684\u6570\u636e\u6743\u9650");
            }
            StopWatch sw = new StopWatch();
            sw.start("\u5b50\u4efb\u52a1\u5904\u7406");
            this.crmExcelProcessStrategy.exportDetailForWebApi(task, process, paramsMap, tmpFile.getAbsolutePath(), functionPermissionVo);
            sw.stop();
            boolean f = FileUtil.exist((String)tmpFilePath) && FileUtil.size((File)tmpFile) > 0L;
            Validate.isTrue((boolean)f, (String)"\u5b50\u4efb\u52a1\u5bfc\u51fa\u5931\u8d25", (Object[])new Object[0]);
            ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
            msgVo.setTaskCode(task.getDetailCode());
            msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            msgVo.setProcessType(ExportDetailProcessEnum.UPLOAD.getCode());
            msgVo.setRemark(ExportDetailProcessEnum.UPLOAD.getFormat());
            msgVo.setAccount(task.getCreateAccount());
            this.exportSendProcessMsgBean.sendMsg(msgVo);
            String fileCode = this.uploadFile(tmpFilePath, fileName);
            Validate.notBlank((CharSequence)fileCode, (String)CharSequenceUtil.format((CharSequence)ERR_MSG_FORMAT, (Object[])new Object[]{fileName}), (Object[])new Object[0]);
            ExportTaskDetailUpdateModelVo vo = new ExportTaskDetailUpdateModelVo();
            vo.setDetailCode(task.getDetailCode());
            vo.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
            vo.setFileCode(fileCode);
            Long lastTaskTimeMillis = sw.getLastTaskTimeMillis();
            vo.setExecuteDuration(lastTaskTimeMillis.intValue());
            this.exportTaskDetailRepository.updateByExportTaskDetailUpdateModelVo(vo);
        }
        finally {
            if (FileUtil.exist((String)tmpFilePath)) {
                FileUtil.del((String)tmpFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detailExcelHandlerForEuropa(ExportTaskProcessVo task, ExportProcess<?> process, FunctionPermissionVo funPermVo) throws CrmExportException {
        log.debug("\u5f00\u59cb\u5904\u7406Europa\u5bfc\u51fa\u4e1a\u52a12");
        String fileName = this.getTaskFileName(task, process);
        File tmpFile = null;
        String tmpFilePath = null;
        String parentPath = this.findExportParentPath(task);
        File mkdir = FileUtil.mkdir((String)parentPath);
        tmpFile = FileUtil.file((File)mkdir, (String)fileName);
        try {
            tmpFilePath = tmpFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("\u5b50\u4efb\u52a1\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (Throwable)e);
            Validate.isTrue((boolean)false, (String)("\u5b50\u4efb\u52a1\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u5931\u8d25" + e.getMessage()), (Object[])new Object[0]);
        }
        try {
            Map<String, Object> paramsMap = this.findParamsMap(task);
            if (StringUtils.isNotBlank((CharSequence)task.getMarsListCode())) {
                log.info("========== \u5df2\u8bbe\u5b9a\u6570\u636e\u5bfc\u51fa\u5b50\u4efb\u52a1\u5339\u914d\u7684\u6570\u636e\u6743\u9650\uff1a{}", (Object)task.getMarsListCode());
            } else {
                log.info("========== \u672a\u8bbe\u5b9a\u6570\u636e\u5bfc\u51fa\u5b50\u4efb\u52a1\u5339\u914d\u7684\u6570\u636e\u6743\u9650");
            }
            StopWatch sw = new StopWatch();
            sw.start("\u5b50\u4efb\u52a1\u5904\u7406");
            this.crmExcelProcessStrategy.exportDetailForEuropa(task, process, paramsMap, tmpFile.getAbsolutePath(), funPermVo);
            sw.stop();
            boolean f = FileUtil.exist((String)tmpFilePath) && FileUtil.size((File)tmpFile) > 0L;
            Validate.isTrue((boolean)f, (String)"\u5b50\u4efb\u52a1\u5bfc\u51fa\u5931\u8d25", (Object[])new Object[0]);
            ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
            msgVo.setTaskCode(task.getDetailCode());
            msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            msgVo.setProcessType(ExportDetailProcessEnum.UPLOAD.getCode());
            msgVo.setRemark(ExportDetailProcessEnum.UPLOAD.getFormat());
            msgVo.setAccount(task.getCreateAccount());
            this.exportSendProcessMsgBean.sendMsg(msgVo);
            String fileCode = this.uploadFile(tmpFilePath, fileName);
            Validate.notBlank((CharSequence)fileCode, (String)CharSequenceUtil.format((CharSequence)ERR_MSG_FORMAT, (Object[])new Object[]{fileName}), (Object[])new Object[0]);
            ExportTaskDetailUpdateModelVo vo = new ExportTaskDetailUpdateModelVo();
            vo.setDetailCode(task.getDetailCode());
            vo.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
            vo.setFileCode(fileCode);
            Long lastTaskTimeMillis = sw.getLastTaskTimeMillis();
            vo.setExecuteDuration(lastTaskTimeMillis.intValue());
            this.exportTaskDetailRepository.updateByExportTaskDetailUpdateModelVo(vo);
        }
        finally {
            if (FileUtil.exist((String)tmpFilePath)) {
                FileUtil.del((String)tmpFilePath);
            }
        }
    }

    private String getTaskFileName(ExportTaskProcessVo task, ExportProcess process) {
        ExportTask exportTaskTemp;
        String fileNameType;
        String fileTempName = process.getTaskFileName(task);
        String string = fileNameType = task.getTotal().equals(task.getPageSize()) ? "\u4e3b\u4efb\u52a1" : "\u5b50\u4efb\u52a1";
        if (StringUtils.isNotBlank((CharSequence)fileTempName)) {
            ExportTask exportTaskTemp2 = this.exportTaskRepository.findByTaskCode(task.getTaskCode());
            if (ObjectUtils.isNotEmpty((Object)((Object)exportTaskTemp2))) {
                return exportTaskTemp2.getFileName();
            }
            return CharSequenceUtil.format((CharSequence)"{}_{}_{}{}", (Object[])new Object[]{fileNameType, fileTempName, task.getDetailCode(), ".xlsx"});
        }
        String fileName = null;
        if (task.getTotal().equals(task.getPageSize()) && ObjectUtils.isNotEmpty((Object)((Object)(exportTaskTemp = this.exportTaskRepository.findByTaskCode(task.getTaskCode()))))) {
            log.info("\u65ad\u70b9-\u6570\u636e3: {}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)((Object)exportTaskTemp)));
            fileName = exportTaskTemp.getFileName();
        }
        if (fileName == null) {
            fileName = CharSequenceUtil.format((CharSequence)"{}_{}_{}_{}{}", (Object[])new Object[]{fileNameType, task.getTaskSource(), task.getCreateAccountName(), task.getDetailCode(), ".xlsx"});
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detailExcelHandler(ExportTaskProcessVo task, ExportProcess process) {
        log.debug("\u81ea\u5b9a\u4e49\u5bfc\u51fa");
        String parentPath = this.findExportParentPath(task);
        String fileName = this.getTaskFileName(task, process);
        String tmpFilePath = parentPath + fileName;
        try {
            Map<String, Object> paramsMap = this.findParamsMap(task);
            this.crmExcelProcessStrategy.exportDetail(task, process, paramsMap, tmpFilePath);
            boolean f = FileUtil.exist((String)tmpFilePath) && FileUtil.size((File)FileUtil.file((String)tmpFilePath)) > 0L;
            Validate.isTrue((boolean)f, (String)"\u5b50\u4efb\u52a1\u5bfc\u51fa\u5931\u8d25", (Object[])new Object[0]);
            ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
            msgVo.setTaskCode(task.getDetailCode());
            msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            msgVo.setProcessType(ExportDetailProcessEnum.UPLOAD.getCode());
            msgVo.setRemark(ExportDetailProcessEnum.UPLOAD.getFormat());
            msgVo.setAccount(task.getCreateAccount());
            this.exportSendProcessMsgBean.sendMsg(msgVo);
            String fileCode = this.uploadFile(tmpFilePath, fileName);
            Validate.notBlank((CharSequence)fileCode, (String)CharSequenceUtil.format((CharSequence)ERR_MSG_FORMAT, (Object[])new Object[]{fileName}), (Object[])new Object[0]);
            ExportTaskDetailUpdateModelVo vo = new ExportTaskDetailUpdateModelVo();
            vo.setDetailCode(task.getDetailCode());
            vo.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
            vo.setFileCode(fileCode);
            this.exportTaskDetailRepository.updateByExportTaskDetailUpdateModelVo(vo);
        }
        finally {
            if (FileUtil.exist((String)tmpFilePath)) {
                FileUtil.del((String)tmpFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detailExcelHandlerForEsParagraph(ExportTaskProcessVo task, ExportProcess process) {
        log.debug("\u81ea\u5b9a\u4e49ES\u5206\u6bb5\u5bfc\u51fa");
        String parentPath = this.findExportParentPath(task);
        String fileName = this.getTaskFileName(task, process);
        String tmpFilePath = parentPath + fileName;
        try {
            Map<String, Object> paramsMap = this.findParamsMap(task);
            this.crmExcelProcessStrategy.exportDetailForEsParagraph(task, process, paramsMap, tmpFilePath);
            boolean f = FileUtil.exist((String)tmpFilePath) && FileUtil.size((File)FileUtil.file((String)tmpFilePath)) > 0L;
            Validate.isTrue((boolean)f, (String)"\u5b50\u4efb\u52a1\u5bfc\u51fa\u5931\u8d25", (Object[])new Object[0]);
            ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
            msgVo.setTaskCode(task.getDetailCode());
            msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            msgVo.setProcessType(ExportDetailProcessEnum.UPLOAD.getCode());
            msgVo.setRemark(ExportDetailProcessEnum.UPLOAD.getFormat());
            msgVo.setAccount(task.getCreateAccount());
            this.exportSendProcessMsgBean.sendMsg(msgVo);
            String fileCode = this.uploadFile(tmpFilePath, fileName);
            Validate.notBlank((CharSequence)fileCode, (String)CharSequenceUtil.format((CharSequence)ERR_MSG_FORMAT, (Object[])new Object[]{fileName}), (Object[])new Object[0]);
            ExportTaskDetailUpdateModelVo vo = new ExportTaskDetailUpdateModelVo();
            vo.setDetailCode(task.getDetailCode());
            vo.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
            vo.setFileCode(fileCode);
            this.exportTaskDetailRepository.updateByExportTaskDetailUpdateModelVo(vo);
        }
        finally {
            if (FileUtil.exist((String)tmpFilePath)) {
                FileUtil.del((String)tmpFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainTaskHandler(ExportTaskProcessVo task) {
        Validate.notNull((Object)task, (String)"\u4efb\u52a1\u5904\u7406\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String lockKey = CharSequenceUtil.format((CharSequence)"bz:crm:ie:ex:{}", (Object[])new Object[]{task.getTaskCode()});
        while (true) {
            if (this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 10)) {
                try {
                    this.taskHandler(task);
                    break;
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
                    log.error("\u5bfc\u51fa\u4efb\u52a1{}\u5904\u7406\u5931\u8d25,err[{}]", (Object)task.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                    this.handlerMainTaskFailed(task.getTaskCode(), e.getMessage(), task.getCreateAccount());
                    break;
                }
                catch (Exception e) {
                    log.error("\u5bfc\u51fa\u4efb\u52a1{}\u5904\u7406\u5931\u8d25,err[{}]", (Object)task.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                    this.handlerMainTaskFailed(task.getTaskCode(), "\u4e3b\u4efb\u52a1\u5904\u7406\u5931\u8d25", task.getCreateAccount());
                    break;
                }
                finally {
                    this.redisMutexService.unlock(lockKey);
                }
            }
            ThreadUtil.safeSleep((long)50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskHandler(ExportTaskProcessVo task) {
        String parentPath = this.findExportParentPath(task);
        ExportTask exportTask = this.exportTaskService.findDetailByTaskCode(task.getTaskCode());
        String account = exportTask.getCreateAccount();
        Validate.notNull((Object)((Object)exportTask), (String)CharSequenceUtil.format((CharSequence)"{}\u5bfc\u51fa\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[]{task.getTaskCode()}), (Object[])new Object[0]);
        if (!exportTask.getExecStatus().equals(ExecStatusEnum.RUNNING.getDictCode()) && !exportTask.getExecStatus().equals(ExecStatusEnum.DEFAULT.getDictCode())) {
            return;
        }
        List<ExportTaskDetail> list = this.exportTaskDetailRepository.findByTaskCodes(Sets.newHashSet((Object[])new String[]{task.getTaskCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)CharSequenceUtil.format((CharSequence)"{}\u5bfc\u51fa\u4efb\u52a1\u5b50\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[]{task.getTaskCode()}), (Object[])new Object[0]);
        Optional<ExportTaskDetail> first = list.stream().filter(a -> ExecStatusEnum.RUNNING.getDictCode().equals(a.getExecStatus()) || ExecStatusEnum.DEFAULT.getDictCode().equals(a.getExecStatus())).findFirst();
        if (first.isPresent()) {
            log.info(CharSequenceUtil.format((CharSequence)"{}\u5bfc\u51fa\u4efb\u52a1\u5b50\u4efb\u52a1\u8fd8\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u6267\u884c\u8be5\u64cd\u4f5c", (Object[])new Object[]{task.getTaskCode()}));
            return;
        }
        List<ExportTaskDetail> finishDetailTaskList = list.stream().filter(a -> ExecStatusEnum.FINISH.getDictCode().equals(a.getExecStatus()) && StringUtils.isNotBlank((CharSequence)a.getFileCode())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(finishDetailTaskList) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5b50\u4efb\u52a1\u751f\u6210\u7684\u6587\u4ef6\u4fe1\u606f", (Object[])new Object[0]);
        ExportProcess<?> process = this.findExportProcess(task.getBusinessCode());
        Integer taskTotal = list.size();
        Integer finishTotal = finishDetailTaskList.size();
        Integer mergeFileMaxCount = Objects.nonNull(process.getMergeFileMaxCount()) ? process.getMergeFileMaxCount().intValue() : this.importExportProperties.getExportProperties().getMergeFileMaxCount();
        if (finishTotal == 1) {
            LinkedHashSet set = Sets.newLinkedHashSet();
            set.add(((ExportTaskDetail)((Object)finishDetailTaskList.get(0))).getFileCode());
            this.finishTask(task, account, set);
            return;
        }
        if (mergeFileMaxCount > 0 && mergeFileMaxCount < exportTask.getTotal()) {
            this.finishTask(task, account, Sets.newLinkedHashSet());
            return;
        }
        if (!Objects.equals(finishTotal, taskTotal)) {
            int cursor = BigDecimal.valueOf(90L).multiply(BigDecimal.valueOf(finishTotal.intValue()).divide(BigDecimal.valueOf(taskTotal.intValue())).setScale(4, 4)).setScale(0, 0).intValue();
            this.exportSendProcessMsgBean.sendTaskProcessMsg(task, ExecStatusEnum.RUNNING.getDictCode(), ExportProcessEnum.RUNNING, cursor, account, true);
        }
        Map<String, String> detailTaskFilePathMap = this.createLocalFileByDetailTask(finishDetailTaskList, parentPath);
        List detailList1 = list.stream().filter(a -> detailTaskFilePathMap.keySet().contains(a.getDetailCode())).sorted(Comparator.comparing(ExportTaskDetail::getPageNo)).collect(Collectors.toList());
        List detailList = (List)this.nebulaToolkitService.copyCollectionByBlankList(detailList1, ExportTaskDetail.class, ExportTaskDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        LinkedHashMap uploadFileMap = this.crmExcelProcessStrategy.merge(task, process, parentPath, detailList, detailTaskFilePathMap);
        Validate.isTrue((!uploadFileMap.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u5408\u5e76\u6587\u4ef6", (Object[])new Object[0]);
        for (Object file : uploadFileMap.values()) {
            Validate.isTrue((FileUtil.exist((String)file) && FileUtil.size((File)FileUtil.file((String)file)) > 0L ? 1 : 0) != 0, (String)"\u5bfc\u51fa\u4efb\u52a1\u672a\u751f\u6210\u6587\u4ef6", (Object[])new Object[0]);
        }
        this.exportSendProcessMsgBean.sendTaskProcessMsg(task, ExecStatusEnum.RUNNING.getDictCode(), ExportProcessEnum.UPLOAD, EXPORT_FILE_UPLOAD, account, true);
        LinkedHashSet fileCodeSet = Sets.newLinkedHashSet();
        try {
            for (Map.Entry entry : uploadFileMap.entrySet()) {
                String fileCode = this.uploadFile((String)entry.getValue(), (String)entry.getKey());
                Validate.notBlank((CharSequence)fileCode, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Object[])new Object[0]);
                fileCodeSet.add(fileCode);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)"\u5408\u5e76\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Object[])new Object[0]);
        }
        finally {
            FileUtil.del((String)parentPath);
        }
        this.finishTask(task, account, fileCodeSet);
    }

    private void finishTask(ExportTaskProcessVo task, String account, LinkedHashSet<String> fileCodeSet) {
        ExportTaskProcessModelDto dto = new ExportTaskProcessModelDto();
        dto.setTaskCode(task.getTaskCode());
        dto.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
        dto.setFileCodeSet(fileCodeSet);
        this.exportTaskService.updateByExportTaskProcessModelDto(dto);
        this.exportSendProcessMsgBean.sendTaskProcessMsg(task, ExecStatusEnum.FINISH.getDictCode(), ExportProcessEnum.END, TOTAL, account, true, fileCodeSet.stream().findFirst().orElse(null));
        this.callBack(task.getTaskCode());
    }

    private Map<String, String> createLocalFileByDetailTask(List<ExportTaskDetail> list, String parentPath) {
        List detailList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getFileCode()) && ExecStatusEnum.FINISH.getDictCode().equals(a.getExecStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailList)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        Map<String, String> mapFileDetail = detailList.stream().collect(Collectors.toMap(ExportTaskDetail::getFileCode, ExportTaskDetail::getDetailCode, (a, b) -> a));
        for (List item : Lists.partition(detailList, (int)10)) {
            HashMap downloadFileVoMap = Maps.newHashMap();
            for (ExportTaskDetail exportTaskDetail : item) {
                byte[] bytes;
                OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(exportTaskDetail.getFileCode());
                if (ordinaryFileVo == null || (bytes = this.fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName())) == null) continue;
                String detailCode = mapFileDetail.get(exportTaskDetail.getFileCode());
                String tmpPath = parentPath + detailCode + ".xlsx";
                FileUtil.writeBytes((byte[])bytes, (String)tmpPath);
                downloadFileVoMap.put(exportTaskDetail.getFileCode(), ordinaryFileVo);
            }
            if (downloadFileVoMap.isEmpty()) continue;
            for (Map.Entry entry : downloadFileVoMap.entrySet()) {
                String detailCode = mapFileDetail.get(entry.getKey());
                String tmpPath = parentPath + detailCode + ".xlsx";
                map.put(detailCode, tmpPath);
            }
        }
        return map;
    }

    private List<OrdinaryFileVo> venusFileUpload(MultipartFile multipartFile) throws IOException {
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setCreator(this.loginUserService.findCurrentAccount());
        base64UploadDto.setFileNanmes(new String[]{multipartFile.getOriginalFilename()});
        base64UploadDto.setBase64Contents(new String[]{Base64Utils.encodeToString((byte[])multipartFile.getBytes())});
        List ordinaryFileVoList = this.fileHandleService.fileUpload(this.subsystem.replace("-", "_"), base64UploadDto, null);
        Validate.notEmpty((Collection)ordinaryFileVoList, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Object[])new Object[0]);
        return ordinaryFileVoList;
    }

    private String uploadFile(String filePath, String fileName) {
        boolean exist = FileUtil.exist((String)filePath);
        Validate.isTrue((boolean)exist, (String)CharSequenceUtil.format((CharSequence)"{}\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[]{fileName}), (Object[])new Object[0]);
        String fileCode = null;
        try (BufferedInputStream is = FileUtil.getInputStream((String)filePath);){
            MultipartFile multipartFile = MultipartFileUtil.getMultipartFile((InputStream)is, (String)fileName);
            OrdinaryFileVo ordinaryFileVo = this.venusFileUpload(multipartFile).get(0);
            fileCode = ordinaryFileVo.getId();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,error[{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
            Validate.isTrue((boolean)false, (String)CharSequenceUtil.format((CharSequence)ERR_MSG_FORMAT, (Object[])new Object[]{fileName}), (Object[])new Object[0]);
        }
        return fileCode;
    }

    private ExportTaskProcessVo exportTaskPrevHandler(String detailCode) {
        String[] str;
        ExportTaskProcessVo task = this.exportTaskService.findExportTaskModelVoByDetailCode(detailCode);
        Validate.notNull((Object)task, (String)CharSequenceUtil.format((CharSequence)"\u5bfc\u51fa\u5b50\u4efb\u52a1\u7f16\u7801\u4e3a{}\u7684\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[]{detailCode}), (Object[])new Object[0]);
        Boolean f = task.getExecStatus().equals(ExecStatusEnum.CANCEL.getDictCode()) || task.getExecStatus().equals(ExecStatusEnum.FINISH.getDictCode());
        Validate.isTrue((f == false ? 1 : 0) != 0, (String)CharSequenceUtil.format((CharSequence)"\u5bfc\u51fa\u5b50\u4efb\u52a1\u7f16\u7801\u4e3a{}\u7684\u4efb\u52a1\u5df2\u5b8c\u6210\u6216\u53d6\u6d88", (Object[])new Object[]{detailCode}), (Object[])new Object[0]);
        if (task.getExecStatus().equals(ExecStatusEnum.DEFAULT.getDictCode())) {
            ExportTaskDetailUpdateModelVo cur = new ExportTaskDetailUpdateModelVo();
            cur.setDetailCode(detailCode);
            cur.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            this.exportTaskDetailRepository.updateByExportTaskDetailUpdateModelVo(cur);
        }
        ExportTaskProcessModelDto dto = new ExportTaskProcessModelDto();
        dto.setTaskCode(task.getTaskCode());
        dto.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        this.exportTaskService.updateByExportTaskProcessModelDto(dto);
        for (String item : str = detailCode.split("_")) {
            if (!"0".equals(item)) continue;
            this.exportSendProcessMsgBean.sendTaskProcessMsg(task, ExecStatusEnum.RUNNING.getDictCode(), ExportProcessEnum.START, task.getCreateAccount(), (Boolean)true);
        }
        return task;
    }

    private Map<String, Object> findParamsMap(ExportTaskProcessVo task) {
        if (Objects.isNull(task) || StringUtils.isBlank((CharSequence)task.getParametersJson())) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        JSONObject jsonObject = JSONUtil.parseObj((String)task.getParametersJson());
        Set set = jsonObject.keySet();
        for (String item : set) {
            map.put(item, jsonObject.get((Object)item));
        }
        return map;
    }

    private String findExportParentPath(ExportTaskProcessVo task) {
        Date now = new Date();
        String root = this.importExportProperties.getRoot();
        if (StringUtils.isBlank((CharSequence)root)) {
            root = FileUtil.getTmpDirPath();
        }
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        return CharSequenceUtil.format((CharSequence)"{}export/{}/{}/{}/{}/", (Object[])new Object[]{root, DateUtil.year((Date)now), DateUtil.month((Date)now), DateUtil.dayOfMonth((Date)now), task.getTaskCode()});
    }

    private void handlerDetailTaskFailed(String taskCode, String detailCode, String msg, String account) {
        ExportTaskDetailUpdateModelVo vo = new ExportTaskDetailUpdateModelVo();
        vo.setDetailCode(detailCode);
        vo.setExecStatus(ExecStatusEnum.FAILED.getDictCode());
        vo.setRemark(msg);
        this.exportTaskDetailRepository.updateByExportTaskDetailUpdateModelVo(vo);
        ExportTaskProcessModelDto exportTaskProcessModelDto = new ExportTaskProcessModelDto();
        exportTaskProcessModelDto.setTaskCode(taskCode);
        exportTaskProcessModelDto.setExecStatus(ExecStatusEnum.FAILED.getDictCode());
        exportTaskProcessModelDto.setRemark(msg);
        this.exportTaskService.updateExecStatus(exportTaskProcessModelDto);
        this.exportSendProcessMsgBean.sendFailedProcessMsg(detailCode, false, msg, account);
        ThreadUtil.sleep((long)500L);
        this.exportSendProcessMsgBean.sendFailedProcessMsg(taskCode, true, msg, account);
        this.callBack(taskCode);
    }

    private void handlerMainTaskFailed(String taskCode, String msg, String account) {
        ExportTaskProcessModelDto dto = new ExportTaskProcessModelDto();
        dto.setTaskCode(taskCode);
        dto.setExecStatus(ExecStatusEnum.FAILED.getDictCode());
        dto.setRemark(msg);
        this.exportTaskService.updateByExportTaskProcessModelDto(dto);
        this.exportSendProcessMsgBean.sendFailedProcessMsg(taskCode, true, msg, account);
        this.callBack(taskCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callBack(String taskCode) {
        block19: {
            if (CollectionUtils.isEmpty(this.notifyEventListeners)) {
                return;
            }
            String lockKey = CharSequenceUtil.format((CharSequence)"bz:crm:ie:export:lock:{}", (Object[])new Object[]{taskCode});
            boolean locked = false;
            try {
                ExportTask exportTask;
                locked = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 5);
                if (!locked) break block19;
                long taskExecutionAfterSleep = this.importExportProperties.getTaskExecutionIntervalSleep();
                if (taskExecutionAfterSleep > 0L) {
                    ThreadUtil.sleep((long)taskExecutionAfterSleep);
                    log.debug("******\u4f11\u7720\u91ca\u653e\u6570\u636e\u5e93\u538b\u529b*********");
                }
                if (Objects.isNull((Object)(exportTask = this.exportTaskRepository.findByTaskCode(taskCode)))) {
                    log.warn("\u6267\u884c\u5931\u8d25\u56de\u8c03\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u5bfc\u51fa\u4efb\u52a1\u4fe1\u606f[{}]", (Object)taskCode);
                    return;
                }
                CallbackStatusEnum callbackStatusEnum = CallbackStatusEnum.getByDictCode((String)exportTask.getCallBackStatus());
                if (Objects.nonNull(callbackStatusEnum)) {
                    log.warn("\u5bfc\u51fa\u4efb\u52a1[{}]\u56de\u8c03,\u8df3\u8fc7\u672c\u6b21\u56de\u8c03\u6267\u884c\u64cd\u4f5c[{}]", (Object)callbackStatusEnum.getValue(), (Object)exportTask.getExecStatus());
                    return;
                }
                ExportTaskEventVo exportTaskEventVo = (ExportTaskEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)exportTask, ExportTaskEventVo.class, HashSet.class, ArrayList.class, new String[0]);
                CallbackStatusEnum callbackStatus = null;
                try {
                    if (ExecStatusEnum.FAILED.getDictCode().equals(exportTask.getExecStatus())) {
                        log.info("\u5bfc\u51fa\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}],\u6267\u884c\u5931\u8d25\u56de\u8c03\u64cd\u4f5c", (Object)taskCode, (Object)exportTask.getExecStatus());
                        this.notifyEventListeners.forEach(eventListener -> eventListener.onFail(exportTaskEventVo));
                        callbackStatus = CallbackStatusEnum.HAVE_CALL_BACK_FAIL;
                    } else if (ExecStatusEnum.FINISH.getDictCode().equals(exportTask.getExecStatus())) {
                        log.info("\u5bfc\u51fa\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}],\u6267\u884c\u6210\u529f\u56de\u8c03\u64cd\u4f5c", (Object)taskCode, (Object)exportTask.getExecStatus());
                        this.notifyEventListeners.forEach(eventListener -> eventListener.onSuccess(exportTaskEventVo));
                        callbackStatus = CallbackStatusEnum.HAVE_CALL_BACK_SUCCESS;
                    } else {
                        log.info("\u5bfc\u51fa\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}],\u6ca1\u6709\u5339\u914d\u7684\u56de\u8c03\u64cd\u4f5c", (Object)taskCode, (Object)exportTask.getExecStatus());
                    }
                }
                catch (Exception e) {
                    log.error("\u5bfc\u51fa\u4efb\u52a1\u6267\u884c\u56de\u8c03\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                if (Objects.nonNull(callbackStatus)) {
                    this.exportTaskRepository.updateCallBackStatusByIds(Lists.newArrayList((Object[])new String[]{exportTask.getId()}), callbackStatus);
                }
            }
            catch (Exception e) {
                log.error("\u5bfc\u51fa\u4efb\u52a1\u6267\u884c\u56de\u8c03\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (locked) {
                    this.redisMutexService.unlock(lockKey);
                }
            }
        }
    }

    public boolean isHaveAsyncGetTotalProcess() {
        return this.haveAsyncGetTotalProcess;
    }
}

