/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import com.biz.crm.common.ie.local.model.dto.ImportTaskModelDto;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import com.biz.crm.common.ie.local.model.vo.ImportTaskUpdateModelVo;
import com.biz.crm.common.ie.local.repository.ImportTaskRepository;
import com.biz.crm.common.ie.local.repository.ImportTemplateDetailRepository;
import com.biz.crm.common.ie.local.repository.ImportTemplateRepository;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.sdk.dto.ImportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.LoadStatusEnum;
import com.biz.crm.common.ie.sdk.event.ImportExportTaskEventListener;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="importTaskService")
public class ImportTaskServiceImpl
implements ImportTaskService {
    @Autowired(required=false)
    private ImportTaskRepository importTaskRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ImportTemplateRepository importTemplateRepository;
    @Autowired(required=false)
    private ImportTemplateDetailRepository importTemplateDetailRepository;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private List<ImportProcess> importProcesses;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<ImportExportTaskEventListener> importExportTaskAuthRecordListeners;

    @Override
    public Page<ImportTask> findByConditions(Pageable pageable, ImportTaskPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ImportTaskPaginationDto());
        dto.setApplicationName(this.importExportProperties.getIeTaskGroup());
        dto.setAppCode(TenantUtils.getTenantCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.importTaskRepository.findByConditions((Page<ImportTask>)page, dto);
    }

    @Override
    public ImportTask findDetailByTaskCode(String taskCode) {
        FileModelVo fileModelVo;
        OrdinaryFileVo fileVo;
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            return null;
        }
        ImportTask task = this.importTaskRepository.findByTaskCode(taskCode);
        HashSet set = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)task.getFileCode())) {
            set.add(task.getFileCode());
        }
        if (StringUtils.isNotBlank((CharSequence)task.getFailedFileCode())) {
            set.add(task.getFailedFileCode());
        }
        if (CollectionUtils.isEmpty((Collection)set)) {
            return task;
        }
        HashMap mapFile = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)set)) {
            for (String fileCode : set) {
                OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(fileCode);
                if (ordinaryFileVo == null) continue;
                mapFile.put(fileCode, ordinaryFileVo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)task.getFileCode()) && Objects.nonNull(fileVo = (OrdinaryFileVo)mapFile.get(task.getFileCode()))) {
            fileModelVo = new FileModelVo();
            fileModelVo.setFileName(fileVo.getOriginalFileName());
            fileModelVo.setFileCode(fileVo.getId());
            task.setFile(fileModelVo);
        }
        if (StringUtils.isNotBlank((CharSequence)task.getFailedFileCode()) && Objects.nonNull(fileVo = (OrdinaryFileVo)mapFile.get(task.getFailedFileCode()))) {
            fileModelVo = new FileModelVo();
            fileModelVo.setFileName(fileVo.getOriginalFileName());
            fileModelVo.setFileCode(fileVo.getId());
            task.setFailedFile(fileModelVo);
        }
        return task;
    }

    @Override
    @Transactional
    public ImportTask create(ImportTask importTask) {
        this.validation(importTask);
        importTask.setTenantCode(TenantUtils.getTenantCode());
        importTask.setTaskCode((String)this.generateCodeService.generateCode("IT", 1).get(0));
        importTask.setExecStatus(ExecStatusEnum.DEFAULT.getDictCode());
        importTask.setLoadStatus(LoadStatusEnum.NO.getDictCode());
        ImportProcess importProcess = this.findImportProcess(importTask.getTemplateCode());
        Validate.notNull((Object)importProcess, (String)"\u5bfc\u5165\u6a21\u677f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Map globalParams = importProcess.getGlobalParams();
        if (globalParams != null && !globalParams.isEmpty()) {
            if (StringUtils.isBlank((CharSequence)importTask.getParametersJson())) {
                importTask.setParametersJson(JSONUtil.toJsonStr((Object)globalParams));
            } else {
                JSONObject parameters = JSON.parseObject((String)importTask.getParametersJson());
                parameters.putAll(globalParams);
                importTask.setParametersJson(JSONUtil.toJsonStr((Object)parameters));
            }
        }
        this.importTaskRepository.saveOrUpdate((Object)importTask);
        String createAccount = this.loginUserService.getLoginAccountName();
        if (!CollectionUtils.isEmpty(this.importExportTaskAuthRecordListeners)) {
            for (ImportExportTaskEventListener listener : this.importExportTaskAuthRecordListeners) {
                listener.onTaskCreate(false, importTask.getTaskCode(), importTask.getAppCode(), importTask.getTenantCode(), importTask.getApplicationName(), createAccount);
            }
        }
        return importTask;
    }

    @Override
    public List<ImportTask> findByImportTaskModelDto(ImportTaskModelDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        return this.importTaskRepository.findByImportTaskModelDto(dto);
    }

    @Override
    @Transactional
    @Deprecated
    public void updateByImportTaskUpdateModelVo(ImportTaskUpdateModelVo vo) {
        Validate.notNull((Object)vo, (String)"\u66f4\u65b0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)vo.getTaskCode(), (String)"\u66f4\u65b0\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)vo.getExecStatus(), (String)"\u4efb\u52a1\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.importTaskRepository.updateByImportTaskUpdateModelVo(vo);
    }

    @Override
    @Transactional
    public void updateLocalStatus(Set<String> taskCodes, String loadStatus) {
        Validate.isTrue((!CollectionUtils.isEmpty(taskCodes) ? 1 : 0) != 0, (String)"\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)loadStatus, (String)"\u52a0\u8f7d\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.importTaskRepository.updateLocalStatus(taskCodes, loadStatus);
    }

    private void validation(ImportTask importTask) {
        Validate.notNull((Object)((Object)importTask), (String)"\u5bfc\u5165\u4efb\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importTask.setAppCode(TenantUtils.getTenantCode());
        importTask.setApplicationName(this.importExportProperties.getIeTaskGroup());
        Validate.notEmpty((CharSequence)importTask.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importTask.getFileCode(), (String)"\u6587\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ImportTemplateDetail detail = this.importTemplateDetailRepository.findDetailByTemplateCode(importTask.getTemplateCode());
        Validate.notNull((Object)((Object)detail), (String)"\u6a21\u677f\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ImportTemplate template = this.importTemplateRepository.findByBusinessCode(detail.getBusinessCode());
        Validate.notNull((Object)((Object)template), (String)"\u6a21\u677f\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        importTask.setTaskName(detail.getTemplateName());
        importTask.setBusinessCode(template.getBusinessCode());
        importTask.setBusinessName(template.getBusinessName());
    }

    private ImportProcess findImportProcess(String code) {
        if (CollectionUtils.isEmpty(this.importProcesses) || StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        Optional<ImportProcess> op = this.importProcesses.stream().filter(item -> item.getTemplateCode().equals(code)).findFirst();
        return op.orElse(null);
    }
}

