/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.strategy;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.bean.ExportSendProcessMsgBean;
import com.biz.crm.common.ie.local.bean.ImportSendProcessMsgBean;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.listener.EasyExcelListener;
import com.biz.crm.common.ie.local.model.ExportExcelHeadModel;
import com.biz.crm.common.ie.local.model.vo.ImportExcelReadModelVo;
import com.biz.crm.common.ie.local.repository.ExportTaskRepository;
import com.biz.crm.common.ie.local.service.strategy.CrmExportExcelReadListener;
import com.biz.crm.common.ie.local.service.strategy.CrmImportExcelReadListener;
import com.biz.crm.common.ie.local.service.strategy.CrmImportExcelReadSaveListener;
import com.biz.crm.common.ie.local.service.strategy.CrmImportExcelReadVerifyListener;
import com.biz.crm.common.ie.local.service.strategy.DynamicImageWriteHandler;
import com.biz.crm.common.ie.sdk.enums.ExcelFileTypeEnum;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.enums.ExportTypeEnum;
import com.biz.crm.common.ie.sdk.enums.ImportDataStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ImportProcessEnum;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExportColumnStrategy;
import com.biz.crm.common.ie.sdk.excel.util.BzExcelUtil;
import com.biz.crm.common.ie.sdk.excel.vo.ColumnVo;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.exception.CrmExportException;
import com.biz.crm.common.ie.sdk.strategy.ImportExcelStrategy;
import com.biz.crm.common.ie.sdk.vo.ExcelFileVo;
import com.biz.crm.common.ie.sdk.vo.ExportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskDetailVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExcludedFieldDetailService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public class DefaultExcelProcessStrategyImpl
implements CrmExcelProcessStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelProcessStrategyImpl.class);
    @Autowired
    private ImportSendProcessMsgBean importMsgBean;
    @Autowired
    private ExportSendProcessMsgBean exportMsgBean;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private ExportSendProcessMsgBean exportSendProcessMsgBean;
    @Autowired(required=false)
    private MarsAuthorityExcludedFieldDetailService marsAuthorityExcludedFieldDetailService;
    @Autowired(required=false)
    private CrmExportColumnStrategy crmExportColumnStrategy;
    @Autowired(required=false)
    private List<ImportExcelStrategy> importExcelStrategies;
    @Value(value="${import.type:#{'default'}}")
    private String importType;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ExportTaskRepository exportTaskRepository;
    @Autowired
    private FileHandleService fileHandleService;

    private ExcelWriter newErrorExcelWriter(File errorFilePath, ImportProcess process) {
        ExportExcelHeadModel excelHeadModel = this.findHead(process.findCrmExcelVoClass());
        ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((File)errorFilePath).head(excelHeadModel.getHeadNameList())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        return excelWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportTaskHandlerResultVo importExcel(ImportProcess process, TaskGlobalParamsVo paramsVo, Map<String, Object> params, Map<String, ExcelFileVo> fileMap) {
        Validate.isTrue((Objects.nonNull(paramsVo) && StringUtils.isNotBlank((CharSequence)paramsVo.getTaskCode()) ? 1 : 0) != 0, (String)"\u4efb\u52a1\u516c\u53c2\u7f16\u7801\u4e3a\u5fc5\u8981\u53c2\u6570", (Object[])new Object[0]);
        ImportTaskHandlerResultVo resultVo = new ImportTaskHandlerResultVo();
        ExcelFileVo originalFile = fileMap.get(ExcelFileTypeEnum.ORIGINAL.getDictCode());
        ExcelFileVo errorFileVo = fileMap.get(ExcelFileTypeEnum.ERROR.getDictCode());
        File errorFilePath = new File(errorFileVo.getPath());
        CrmExcelImport crmExcelImport = process.findCrmExcelVoClass().getAnnotation(CrmExcelImport.class);
        ImportExcelReadModelVo readVo = new ImportExcelReadModelVo();
        readVo.setMsgBean(this.importMsgBean);
        readVo.setProcess((ImportProcess<CrmExcelVo>)process);
        readVo.setParamsVo(paramsVo);
        readVo.setParams(params);
        ExcelWriter excelWriter = null;
        int failedNum = 0;
        try {
            AnalysisEventListener saveDbListener;
            int totalRow = this.findExcelTotalRowIgnoreBlankLines(originalFile.getPath(), crmExcelImport.sheetNo(), process);
            Validate.isTrue((totalRow > crmExcelImport.startRow() ? 1 : 0) != 0, (String)"\u5bfc\u5165excel\u603b\u8bb0\u5f55\u6570\u987b\u5927\u4e8e\u5f00\u59cb\u5904\u7406\u884c\u6570", (Object[])new Object[0]);
            resultVo.setTotal(totalRow - crmExcelImport.startRow());
            excelWriter = this.newErrorExcelWriter(errorFilePath, process);
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
            readVo.setTotal(resultVo.getTotal());
            List importExcelStrategyList = this.importExcelStrategies.stream().filter(importExcelStrategy -> importExcelStrategy.importExcelType().equals(this.importType)).collect(Collectors.toList());
            Validate.isTrue((!CollectionUtils.isEmpty(importExcelStrategyList) ? 1 : 0) != 0, (String)"\u5bfc\u5165\u5339\u914d\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5yml\u914d\u7f6e\u4fe1\u606fimport.type\u662f\u5426\u914d\u7f6e", (Object[])new Object[0]);
            ImportExcelStrategy importExcelStrategy2 = (ImportExcelStrategy)importExcelStrategyList.get(0);
            if (readVo.getProcess().importBeforeValidationFlag()) {
                CrmImportExcelReadVerifyListener verifyDbListener = new CrmImportExcelReadVerifyListener(readVo, excelWriter, writeSheet, paramsVo.getCreateAccount(), importExcelStrategy2);
                ((ExcelReaderSheetBuilder)EasyExcelFactory.read((String)originalFile.getPath(), (ReadListener)verifyDbListener).sheet().headRowNumber(Integer.valueOf(crmExcelImport.startRow()))).doRead();
                ThreadUtil.sleep((Number)50, (TimeUnit)TimeUnit.MILLISECONDS);
                this.importMsgBean.sendProcessMsg(readVo.getParamsVo().getTaskCode(), readVo.getTotal(), readVo.getTotal(), 0, readVo.getSuccessNum(), readVo.getFailedNum(), readVo.getParamsVo().getCreateAccount(), ImportProcessEnum.RUNNING_VERIFY);
                failedNum = Integer.max(readVo.getFailedNum(), 0);
                readVo.setFailedNum(failedNum);
                if (failedNum > 0) {
                    this.importMsgBean.sendProcessMsg(readVo.getParamsVo().getTaskCode(), ImportProcessEnum.VERIFY_FAIL, readVo.getParamsVo().getCreateAccount());
                    saveDbListener = null;
                } else {
                    this.importMsgBean.sendProcessMsg(readVo.getParamsVo().getTaskCode(), ImportProcessEnum.VERIFY_SUCCESS, readVo.getParamsVo().getCreateAccount());
                    excelWriter.close();
                    FileUtil.del((File)errorFilePath);
                    excelWriter = this.newErrorExcelWriter(errorFilePath, process);
                    saveDbListener = new CrmImportExcelReadSaveListener(readVo, excelWriter, writeSheet, paramsVo.getCreateAccount(), importExcelStrategy2);
                }
            } else {
                saveDbListener = new CrmImportExcelReadListener(readVo, excelWriter, writeSheet, paramsVo.getCreateAccount(), importExcelStrategy2);
            }
            if (saveDbListener != null) {
                ((ExcelReaderSheetBuilder)EasyExcelFactory.read((String)originalFile.getPath(), (ReadListener)saveDbListener).sheet().headRowNumber(Integer.valueOf(crmExcelImport.startRow()))).doRead();
                ThreadUtil.sleep((Number)50, (TimeUnit)TimeUnit.MILLISECONDS);
                this.importMsgBean.sendProcessMsg(readVo.getParamsVo().getTaskCode(), readVo.getTotal(), readVo.getTotal(), readVo.getTotal(), readVo.getSuccessNum(), readVo.getFailedNum(), readVo.getParamsVo().getCreateAccount(), ImportProcessEnum.RUNNING_SAVE);
                if (readVo.getFailedNum() == 0) {
                    resultVo.setImportDataStatus(ImportDataStatusEnum.IMPORT_SUCCESS);
                } else {
                    resultVo.setImportDataStatus(readVo.getTotal() == readVo.getFailedNum() ? ImportDataStatusEnum.IMPORT_FAILED : ImportDataStatusEnum.IMPORT_FAILED_SECTION);
                }
            } else {
                resultVo.setImportDataStatus(readVo.getTotal() == readVo.getFailedNum() ? ImportDataStatusEnum.VERIFY_FAILED : ImportDataStatusEnum.VERIFY_FAILED_SECTION);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** \u5bfc\u5165\u51fa\u9519\u4e86 ****", (Throwable)e);
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("**** \u5bfc\u5165\u51fa\u9519\u4e86 ****", (Throwable)e);
            Validate.isTrue((boolean)false, (String)String.format("\u5bfc\u5165\u51fa\u9519\u4e86:%s", e.getMessage()), (Object[])new Object[0]);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
            if ((failedNum = Integer.max(readVo.getFailedNum(), 0)) == 0) {
                FileUtil.del((File)errorFilePath);
            }
        }
        resultVo.setFailedNum(failedNum);
        return resultVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDetail(ExportTaskProcessVo task, ExportProcess process, Map<String, Object> paramsMap, String filePath) {
        List<List<Object>> excelDataList = null;
        Integer count = null;
        ExportExcelHeadModel excelHeadModel = null;
        JSONArray data = process.getData(task, paramsMap);
        Validate.isTrue((Objects.nonNull(data) && !data.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e", (Object[])new Object[0]);
        count = BzExcelUtil.findMsgCount((Integer)task.getPageSize());
        excelHeadModel = this.findHeadByCustomize(task, process);
        if (!CollectionUtils.isEmpty(excelHeadModel.getImageDataIndexList())) {
            int maxImageRowNum = this.importExportProperties.getExportProperties().getMaxImageRowNum();
            Validate.isTrue((task.getTotal() <= maxImageRowNum ? 1 : 0) != 0, (String)"\u5f53\u524d\u5bfc\u51fa\u4efb\u52a1\u6d89\u53ca\u56fe\u7247\u5bfc\u51fa,\u6700\u5927\u53ea\u53ef\u5bfc\u51fa%s\u6761\u6570\u636e", (long)maxImageRowNum);
        }
        Validate.isTrue((!CollectionUtils.isEmpty(excelDataList = this.findExportData(data, excelHeadModel)) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5bfc\u51fa\u6570\u636e", (Object[])new Object[0]);
        ExcelWriter excelWriter = null;
        if (!FileUtil.exist((String)filePath)) {
            FileUtil.touch((String)filePath);
        }
        try {
            excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((String)filePath).head(excelHeadModel.getHeadNameList())).registerWriteHandler((WriteHandler)new DynamicImageWriteHandler(excelHeadModel, this.fileHandleService))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
            String account = task.getCreateAccount();
            if (count <= 10) {
                excelWriter.write(excelDataList, writeSheet);
                excelDataList = null;
            } else {
                List result = Lists.partition(excelDataList, (int)count);
                excelDataList = null;
                int pageSize = result.size();
                for (int stepNum = 0; stepNum < pageSize; ++stepNum) {
                    List item = (List)result.get(stepNum);
                    excelWriter.write((Collection)item, writeSheet);
                    int cursor = (1 + stepNum) * 100 / pageSize;
                    this.postStepWebSocketMsg(task, account, cursor, false);
                }
            }
            Thread.sleep(1000L);
            this.postStepWebSocketMsg(task, account, 100, false);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** \u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("**** \u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            Validate.isTrue((boolean)false, (String)"excel\u5bfc\u51fa\u51fa\u9519\u4e86", (Object[])new Object[0]);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
        }
    }

    public void exportDetailForEsParagraph(ExportTaskProcessVo task, ExportProcess process, Map<String, Object> paramsMap, String filePath) {
        ExportExcelHeadModel excelHeadModel = this.findHeadByCustomize(task, process);
        if (!CollectionUtils.isEmpty(excelHeadModel.getImageDataIndexList())) {
            int maxImageRowNum = this.importExportProperties.getExportProperties().getMaxImageRowNum();
            Validate.isTrue((task.getTotal() <= maxImageRowNum ? 1 : 0) != 0, (String)"\u5f53\u524d\u5bfc\u51fa\u4efb\u52a1\u6d89\u53ca\u56fe\u7247\u5bfc\u51fa,\u6700\u5927\u53ea\u53ef\u5bfc\u51fa%s\u6761\u6570\u636e", (long)maxImageRowNum);
        }
        if (!FileUtil.exist((String)filePath)) {
            FileUtil.touch((String)filePath);
        }
        try (ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((String)filePath).head(excelHeadModel.getHeadNameList())).registerWriteHandler((WriteHandler)new DynamicImageWriteHandler(excelHeadModel, this.fileHandleService))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();){
            List paragraphFieldRanges = task.getTotalParagraphFieldRanges();
            paragraphFieldRanges.forEach(ranges -> {
                task.setQueryParagraphFieldRanges(ranges);
                JSONArray data = process.getData(task, paramsMap);
                Validate.isTrue((Objects.nonNull(data) && !data.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e", (Object[])new Object[0]);
                List<List<Object>> excelDataList = this.findExportData(data, excelHeadModel);
                Validate.isTrue((!CollectionUtils.isEmpty(excelDataList) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5bfc\u51fa\u6570\u636e", (Object[])new Object[0]);
                WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
                excelWriter.write(excelDataList, writeSheet);
            });
            Thread.sleep(1000L);
            this.postStepWebSocketMsg(task, task.getCreateAccount(), 100, false);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** \u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("**** \u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            Validate.isTrue((boolean)false, (String)"excel\u5bfc\u51fa\u51fa\u9519\u4e86", (Object[])new Object[0]);
        }
    }

    public void exportDetailForEuropa(ExportTaskProcessVo task, ExportProcess<?> process, Map<String, Object> paramsMap, String filePath, FunctionPermissionVo funPermVo) throws CrmExportException {
        StopWatch sw = null;
        if (log.isDebugEnabled()) {
            sw = new StopWatch();
            sw.start("\u83b7\u53d6\u6570\u636e\u89c6\u56fe\u8868\u5934");
        }
        funPermVo.setParamsJson(task.getParametersJson());
        List showDataviewColumn = this.crmExportColumnStrategy.getShowDataviewColumn(funPermVo);
        List columnList = Optional.of(showDataviewColumn).orElseThrow(() -> new IllegalArgumentException("\u672a\u83b7\u53d6\u5230Europa\u89c6\u56fe\u7684\u53ef\u67e5\u770b\u5bf9\u8c61"));
        Validate.isTrue((false == columnList.isEmpty() ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u3010%s\u3011\u5f53\u524d\u65e0\u53ef\u5bfc\u51fa\u5b57\u6bb5\u6388\u6743", (Object[])new Object[]{task.getBusinessCode()});
        if (log.isDebugEnabled()) {
            sw.stop();
            sw.start("\u521b\u5efa\u6587\u4ef6");
        }
        if (!FileUtil.exist((String)filePath)) {
            FileUtil.touch((String)filePath);
        }
        if (log.isDebugEnabled()) {
            sw.stop();
        }
        try {
            ExportExcelHeadModel excelHeadModel;
            if (log.isDebugEnabled()) {
                sw.start("\u8bfb\u53d6\u6570\u636e\u5e93\u5e76\u5199\u5165\u6587\u4ef6");
            }
            if (!CollectionUtils.isEmpty((excelHeadModel = this.findHeadByEuropa(columnList)).getImageDataIndexList())) {
                int maxImageRowNum = this.importExportProperties.getExportProperties().getMaxImageRowNum();
                Validate.isTrue((task.getTotal() <= maxImageRowNum ? 1 : 0) != 0, (String)"\u5f53\u524d\u5bfc\u51fa\u4efb\u52a1\u6d89\u53ca\u56fe\u7247\u5bfc\u51fa,\u6700\u5927\u53ea\u53ef\u5bfc\u51fa%s\u6761\u6570\u636e", (long)maxImageRowNum);
            }
            this.exportDetailWithPage(filePath, excelHeadModel, task, process, paramsMap, ExportTypeEnum.EUROPA_EXPORT, columnList);
            if (log.isDebugEnabled()) {
                sw.stop();
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** \u6570\u636e\u89c6\u56fe-\u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            throw new CrmExportException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            log.error("**** \u6570\u636e\u89c6\u56fe-\u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            throw new CrmExportException(e.getMessage(), e.getCause());
        }
        finally {
            if (log.isDebugEnabled() && sw != null) {
                log.debug("{}", (Object)sw.prettyPrint());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u4efb\u52a1{},\u6570\u636e\u91cf{},\u6587\u4ef6{},\u6267\u884c\u7ed3\u679c{}", new Object[]{task.getDetailCode(), task.getPageSize(), filePath, sw.prettyPrint()});
        }
    }

    public void exportDetailForWebApi(ExportTaskProcessVo task, ExportProcess<?> process, Map<String, Object> paramsMap, String absolutePath, FunctionPermissionVo functionPermissionVo) throws CrmExportException {
        StopWatch sw = null;
        if (log.isDebugEnabled()) {
            sw = new StopWatch();
            sw.start("\u83b7\u53d6webApi\u5bfc\u51fa\u8868\u5934");
        }
        functionPermissionVo.setParamsJson(task.getParametersJson());
        List showDataviewColumn = this.crmExportColumnStrategy.getShowDataviewColumn(functionPermissionVo);
        List columnList = Optional.of(showDataviewColumn).orElseThrow(() -> new IllegalArgumentException("\u672a\u83b7\u53d6\u5230\u9875\u9762\u914d\u7f6e\u7684\u53ef\u67e5\u770b\u5bf9\u8c61"));
        Validate.isTrue((false == columnList.isEmpty() ? 1 : 0) != 0, (String)"\u9875\u9762\u914d\u7f6e\u3010%s\u3011\u5f53\u524d\u65e0\u53ef\u5bfc\u51fa\u5b57\u6bb5\u6388\u6743", (Object[])new Object[]{task.getBusinessCode()});
        if (log.isDebugEnabled()) {
            sw.stop();
        }
        if (log.isDebugEnabled()) {
            sw.start("\u521b\u5efa\u6587\u4ef6");
        }
        if (!FileUtil.exist((String)absolutePath)) {
            FileUtil.touch((String)absolutePath);
        }
        if (log.isDebugEnabled()) {
            sw.stop();
        }
        try {
            ExportExcelHeadModel excelHeadModel;
            if (log.isDebugEnabled()) {
                sw.start("\u8bfb\u53d6\u6570\u636e\u5e93\u5e76\u5199\u5165\u6587\u4ef6");
            }
            if (!CollectionUtils.isEmpty((excelHeadModel = this.findHeadByEuropa(columnList)).getImageDataIndexList())) {
                int maxImageRowNum = this.importExportProperties.getExportProperties().getMaxImageRowNum();
                Validate.isTrue((task.getTotal() <= maxImageRowNum ? 1 : 0) != 0, (String)"\u5f53\u524d\u5bfc\u51fa\u4efb\u52a1\u6d89\u53ca\u56fe\u7247\u5bfc\u51fa,\u6700\u5927\u53ea\u53ef\u5bfc\u51fa%s\u6761\u6570\u636e", (long)maxImageRowNum);
            }
            this.exportDetailWithPage(absolutePath, excelHeadModel, task, process, paramsMap, ExportTypeEnum.API_EXPORT, columnList);
            if (log.isDebugEnabled()) {
                sw.stop();
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** webApi-\u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            throw new CrmExportException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            log.error("**** webApi-\u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
            throw new CrmExportException(e.getMessage(), e.getCause());
        }
        finally {
            if (log.isDebugEnabled() && sw != null) {
                log.debug("{}", (Object)sw.prettyPrint());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u4efb\u52a1{},\u6570\u636e\u91cf{},\u6587\u4ef6{},\u6267\u884c\u7ed3\u679c{}", new Object[]{task.getDetailCode(), task.getPageSize(), absolutePath, sw.prettyPrint()});
        }
    }

    private void exportDetailWithPage(String filePath, ExportExcelHeadModel excelHeadModel, ExportTaskProcessVo task, ExportProcess<?> process, Map<String, Object> paramsMap, ExportTypeEnum exportType, List<ColumnVo> columnList) throws Exception {
        try (ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((String)filePath).head(excelHeadModel.getHeadNameList())).registerWriteHandler((WriteHandler)new DynamicImageWriteHandler(excelHeadModel, this.fileHandleService))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();){
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
            String createAccount = task.getCreateAccount();
            int splitPageSize = process.getPageSize();
            int queryPageSize = Objects.nonNull(process.getQueryPageSize()) && process.getQueryPageSize() > 0 ? process.getQueryPageSize().intValue() : this.importExportProperties.getExportProperties().getQueryPageSize();
            Validate.isTrue((splitPageSize % queryPageSize == 0 ? 1 : 0) != 0, (String)"\u5bfc\u51fa\u5b50\u4efb\u52a1\u62c6\u5206\u5927\u5c0f\u5fc5\u987b\u662f\u67e5\u8be2\u6570\u636e\u5206\u9875\u5927\u5c0f\u7684\u6574\u6570\u500d!", (Object[])new Object[0]);
            int startPageNo = task.getPageNo() * (splitPageSize / queryPageSize);
            int endPageNo = (task.getPageNo() + 1) * (splitPageSize / queryPageSize) - 1;
            int dealTotal = 0;
            for (int pageNo = startPageNo; pageNo <= endPageNo; ++pageNo) {
                List<List<Object>> excelDataList;
                paramsMap.put("commonPageSize", queryPageSize);
                paramsMap.put("commonPageNo", pageNo);
                JSONArray data = process.getData(task, paramsMap);
                if (Objects.isNull(data) || data.isEmpty()) {
                    Validate.isTrue((pageNo > startPageNo ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e", (Object[])new Object[0]);
                    break;
                }
                dealTotal += data.size();
                List dataList = data.stream().map(JSONUtil::parseObj).collect(Collectors.toList());
                switch (exportType) {
                    case API_EXPORT: 
                    case EUROPA_EXPORT: {
                        dataList = this.crmExportColumnStrategy.fullDictCode(dataList, columnList);
                        excelDataList = this.findExportDataForEuropa(dataList, process, task, columnList);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u7c7b\u578b");
                    }
                }
                excelWriter.write(excelDataList, writeSheet);
                this.postStepWebSocketMsg(task, createAccount, dealTotal * 100 / task.getTotal(), false);
            }
            Thread.sleep(500L);
            this.postStepWebSocketMsg(task, createAccount, 100, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postStepWebSocketMsg(ExportTaskProcessVo task, String account, int cursor, Boolean mainFlag) {
        try {
            this.exportSendProcessMsgBean.sendTaskProcessMsg(task, ExecStatusEnum.RUNNING.getDictCode(), ExportProcessEnum.RUNNING, cursor, account, mainFlag);
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            ThreadUtil.sleep((long)50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> merge(ExportTaskProcessVo task, ExportProcess process, String parentPath, List<ExportTaskDetailVo> list, Map<String, String> tmpFileMap) {
        ExportExcelHeadModel excelHeadModel;
        List columnList;
        FunctionPermissionVo funPermVo;
        String functionCode;
        String parentCode;
        boolean isWebApiExport;
        int pageSize;
        Validate.isTrue((Objects.nonNull(task) && StringUtils.isNotBlank((CharSequence)task.getTaskCode()) ? 1 : 0) != 0, (String)"\u5bfc\u51fa\u4e3b\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String taskCode = task.getTaskCode();
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u5b50\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        for (ExportTaskDetailVo item : list) {
            String s = tmpFileMap.get(item.getDetailCode());
            Validate.notBlank((CharSequence)s, (String)CharSequenceUtil.format((CharSequence)"{}\u5b50\u4efb\u52a1\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Object[])new Object[]{item.getDetailCode()}), (Object[])new Object[0]);
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (list.size() == 1) {
            map.put(taskCode + ".xlsx", tmpFileMap.get(list.get(0).getDetailCode()));
            return map;
        }
        int maxSize = this.importExportProperties.getExportProperties().getExcelMaxCount();
        Validate.isTrue((maxSize > (pageSize = list.get(0).getPageSize().intValue()) ? 1 : 0) != 0, (String)"\u6700\u5927\u5bfc\u51fa\u6570\u5fc5\u987b\u5927\u4e8e\u5904\u7406\u5668\u9875\u6570", (Object[])new Object[0]);
        int splitSize = maxSize / pageSize;
        int i = 0;
        int cursor = 0;
        int size = list.size();
        int startRow = 1;
        String businessCode = task.getBusinessCode();
        boolean isEuropaExport = "MDM_EUROPA_EXPORT".equalsIgnoreCase(businessCode) || "MDM_EUROPA_EXPORT_ASYNC".equalsIgnoreCase(businessCode);
        boolean bl = isWebApiExport = "EXPORT_WEB_API".equalsIgnoreCase(businessCode) || "EXPORT_WEB_API_ASYNC".equalsIgnoreCase(businessCode);
        if (isEuropaExport) {
            parentCode = task.getParentCode();
            functionCode = task.getFunctionCode();
            funPermVo = new FunctionPermissionVo();
            funPermVo.setFunctionCode(functionCode);
            funPermVo.setParentCode(parentCode);
            funPermVo.setParamsJson(task.getParametersJson());
            columnList = this.crmExportColumnStrategy.getShowDataviewColumn(funPermVo);
            excelHeadModel = this.findHeadByEuropa(columnList);
        } else if (isWebApiExport) {
            parentCode = task.getParentCode();
            functionCode = task.getFunctionCode();
            funPermVo = new FunctionPermissionVo();
            funPermVo.setFunctionCode(functionCode);
            funPermVo.setParentCode(parentCode);
            funPermVo.setParamsJson(task.getParametersJson());
            columnList = this.crmExportColumnStrategy.getShowDataviewColumn(funPermVo);
            excelHeadModel = this.findHeadByEuropa(columnList);
        } else {
            Class crmExcelVoClass = process.findCrmExcelVoClass();
            CrmExcelExport crmExcelExport = crmExcelVoClass.getAnnotation(CrmExcelExport.class);
            Validate.notNull((Object)crmExcelExport, (String)"\u5bfc\u51fa\u4e1a\u52a1\u672a\u914d\u7f6e@CrmExcelExport\u6ce8\u89e3", (Object[])new Object[0]);
            startRow = crmExcelExport.startRow();
            excelHeadModel = this.findHeadByCustomize(task, process);
        }
        List partition = Lists.partition(list, (int)splitSize);
        for (List item : partition) {
            ExportTask exportTaskTemp;
            ExcelWriter excelWriter = null;
            String fileName = CharSequenceUtil.format((CharSequence)"\u4e3b\u6587\u4ef6_{}_{}_{}{}", (Object[])new Object[]{task.getTaskSource(), taskCode, i, ".xlsx"});
            String fileTempName = process.getTaskFileName(task);
            if (StringUtils.isNotBlank((CharSequence)fileTempName)) {
                fileName = CharSequenceUtil.format((CharSequence)"{}_{}{}", (Object[])new Object[]{fileTempName, i, ".xlsx"});
            }
            if (ObjectUtils.isNotEmpty((Object)((Object)(exportTaskTemp = this.exportTaskRepository.findByTaskCode(taskCode)))) && partition.size() <= 1) {
                fileName = exportTaskTemp.getFileName();
            }
            try {
                excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((String)(parentPath + fileName)).head(excelHeadModel.getHeadNameList())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
                WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
                Integer count = 100;
                for (ExportTaskDetailVo detail : item) {
                    String curPath = tmpFileMap.get(detail.getDetailCode());
                    Validate.isTrue((FileUtil.exist((String)curPath) && FileUtil.size((File)FileUtil.file((String)curPath)) > 0L ? 1 : 0) != 0, (String)CharSequenceUtil.format((CharSequence)"\u672a\u52a0\u8f7d\u5230\u5b50\u4efb\u52a1{}\u5bf9\u5e94\u7684\u6587\u4ef6", (Object[])new Object[]{detail.getDetailCode()}), (Object[])new Object[0]);
                    ((ExcelReaderSheetBuilder)EasyExcelFactory.read((String)curPath, (ReadListener)new CrmExportExcelReadListener(count, excelWriter, writeSheet)).sheet().headRowNumber(Integer.valueOf(startRow))).doRead();
                    this.sendExportMergeProcessMsg(++cursor, size, task.getTaskCode());
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
                log.error("**** \u81ea\u5b9a\u4e49-\u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
                Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("**** \u81ea\u5b9a\u4e49-\u5bfc\u51fa\u51fa\u9519\u4e86 ****", (Throwable)e);
                Validate.isTrue((boolean)false, (String)"\u5bfc\u51fa\u51fa\u9519\u4e86", (Object[])new Object[0]);
            }
            finally {
                if (excelWriter != null) {
                    excelWriter.close();
                }
                map.put(fileName, parentPath + fileName);
            }
            ++i;
        }
        return map;
    }

    private ExportExcelHeadModel findHead(Class<?> processClass) {
        ExportExcelHeadModel exportExcelHeadModel = new ExportExcelHeadModel();
        LinkedList headNameList = Lists.newLinkedList();
        LinkedList fieldNameList = Lists.newLinkedList();
        List fields = BzExcelUtil.findCrmExcelColumnField(processClass);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)fields) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u64cd\u4f5c\u5b9e\u4f53\u7684\u6807\u9898\u4fe1\u606f", (Object[])new Object[0]);
        int imageDataIndex = 0;
        HashSet imageDataIndexList = Sets.newHashSet();
        for (BzExcelUtil.CrmExcelColumnField field : fields) {
            headNameList.add(Arrays.asList(field.getTitle()));
            fieldNameList.add(field.getField().getName());
            CrmExcelColumn crmExcelColumn = field.getColumn();
            if (Objects.nonNull(crmExcelColumn) && crmExcelColumn.isImage()) {
                imageDataIndexList.add(imageDataIndex);
            }
            ++imageDataIndex;
        }
        exportExcelHeadModel.setHeadNameList(headNameList);
        exportExcelHeadModel.setFieldNameList(fieldNameList);
        exportExcelHeadModel.setImageDataIndexList(imageDataIndexList);
        return exportExcelHeadModel;
    }

    private ExportExcelHeadModel findHeadByEuropa(List<ColumnVo> showDataviewColumn) {
        LinkedList headerList = Lists.newLinkedList();
        LinkedList fieldNameList = Lists.newLinkedList();
        int imageDataIndex = 0;
        HashSet imageDataIndexList = Sets.newHashSet();
        for (ColumnVo columnVo : showDataviewColumn) {
            ArrayList header = Lists.newArrayList();
            header.add(columnVo.getTitle());
            headerList.add(header);
            fieldNameList.add(columnVo.getField());
            if (Boolean.TRUE.equals(columnVo.getExportImage())) {
                imageDataIndexList.add(imageDataIndex);
            }
            ++imageDataIndex;
        }
        ExportExcelHeadModel exportExcelHeadModel = new ExportExcelHeadModel();
        exportExcelHeadModel.setHeadNameList(headerList);
        exportExcelHeadModel.setFieldNameList(fieldNameList);
        exportExcelHeadModel.setImageDataIndexList(imageDataIndexList);
        return exportExcelHeadModel;
    }

    private ExportExcelHeadModel findHeadByCustomize(ExportTaskProcessVo task, ExportProcess exportProcess) {
        LinkedList headNameList = Lists.newLinkedList();
        LinkedList fieldNameList = Lists.newLinkedList();
        List fields = BzExcelUtil.findCrmExcelColumnField((Class)exportProcess.findCrmExcelVoClass());
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)fields) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u64cd\u4f5c\u5b9e\u4f53\u7684\u6807\u9898\u4fe1\u606f", (Object[])new Object[0]);
        FunctionPermissionVo funPermVo = new FunctionPermissionVo();
        funPermVo.setFunctionCode(task.getFunctionCode());
        funPermVo.setParentCode(task.getParentCode());
        List showDataViewColumnList = this.crmExportColumnStrategy.getShowDataviewColumn(funPermVo);
        showDataViewColumnList = (List)ObjectUtils.defaultIfNull((Object)showDataViewColumnList, (Object)Lists.newArrayList());
        Set dataViewColumnNames = showDataViewColumnList.stream().map(ColumnVo::getField).collect(Collectors.toSet());
        int imageDataIndex = 0;
        HashSet imageDataIndexList = Sets.newHashSet();
        for (BzExcelUtil.CrmExcelColumnField field : fields) {
            if (Boolean.TRUE.equals(exportProcess.isColumnUniteMarsAndConfig()) && !dataViewColumnNames.contains(field.getField().getName())) continue;
            headNameList.add(Arrays.asList(field.getTitle()));
            fieldNameList.add(field.getField().getName());
            CrmExcelColumn crmExcelColumn = field.getColumn();
            if (Objects.nonNull(crmExcelColumn) && crmExcelColumn.isImage()) {
                imageDataIndexList.add(imageDataIndex);
            }
            ++imageDataIndex;
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)headNameList) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u5bfc\u51fa\u5b57\u6bb5", (Object[])new Object[0]);
        ExportExcelHeadModel exportExcelHeadModel = new ExportExcelHeadModel();
        exportExcelHeadModel.setHeadNameList(headNameList);
        exportExcelHeadModel.setFieldNameList(fieldNameList);
        exportExcelHeadModel.setImageDataIndexList(imageDataIndexList);
        return exportExcelHeadModel;
    }

    private Integer findExcelTotalRow(String path, Integer sheetNo) {
        ExcelReader excelReader = EasyExcelFactory.read((String)path).build().read(new ReadSheet[]{new ReadSheet(sheetNo)});
        Integer total = excelReader.analysisContext().readRowHolder().getRowIndex() + 1;
        excelReader.close();
        return total;
    }

    private int findExcelTotalRowIgnoreBlankLines(String path, Integer sheetNo, ImportProcess process) {
        EasyExcelListener easyExcelListener = new EasyExcelListener(true, process.getLimitRowNum());
        ExcelReader excelReader = EasyExcelFactory.read((String)path, (ReadListener)easyExcelListener).build().read(new ReadSheet[]{new ReadSheet(sheetNo)});
        List<Object> list = easyExcelListener.getList(Object.class);
        int total = CollectionUtils.isEmpty(list) || list.size() == 0 ? excelReader.analysisContext().readRowHolder().getRowIndex() + 1 : list.size() + 1;
        excelReader.close();
        return total;
    }

    private List<List<Object>> findExportDataForEuropa(List<JSONObject> dataList, ExportProcess<?> process, ExportTaskProcessVo task, List<ColumnVo> columnList) {
        List exportColumn;
        LinkedList list = Lists.newLinkedList();
        List<Object> allowExportColumn = Lists.newLinkedList();
        Set allowFields = null;
        if (StringUtils.isNotBlank((CharSequence)task.getMarsListCode())) {
            allowFields = this.marsAuthorityExcludedFieldDetailService.findByListCode(task.getMarsListCode());
        }
        if (this.crmExportColumnStrategy != null && !CollectionUtils.isEmpty(exportColumn = columnList.stream().map(ColumnVo::getField).collect(Collectors.toList()))) {
            if (!CollectionUtils.isEmpty((Collection)allowFields)) {
                for (String column : exportColumn) {
                    if (!allowFields.contains(column)) continue;
                    allowExportColumn.add(column);
                }
            } else {
                allowExportColumn = exportColumn;
            }
        }
        if (allowExportColumn.isEmpty()) {
            log.info("\u6570\u636e\u89c6\u56fe\u7981\u6b62\u5bfc\u51fa\u6570\u636e\uff0c\u8fd4\u56de\u7a7a\u8868\u683c");
            return list;
        }
        for (JSONObject obj : dataList) {
            LinkedList cur = Lists.newLinkedList();
            for (String string : allowExportColumn) {
                Object orDefault = obj.getOrDefault((Object)string, null);
                cur.add(orDefault);
            }
            list.add(cur);
        }
        return list;
    }

    private List<List<Object>> findExportData(JSONArray data, ExportExcelHeadModel excelHeadModel) {
        List<String> fieldNameList = excelHeadModel.getFieldNameList();
        ArrayList resultList = Lists.newArrayList();
        for (Object o : data) {
            JSONObject obj = JSONUtil.parseObj(o);
            LinkedList cur = Lists.newLinkedList();
            for (String fieldName : fieldNameList) {
                Object filedValue = obj.getOrDefault((Object)fieldName, null);
                if (Objects.isNull(filedValue)) {
                    String fieldNameByLowerCamel = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
                    filedValue = obj.getOrDefault((Object)fieldNameByLowerCamel, null);
                }
                cur.add(filedValue);
            }
            resultList.add(cur);
        }
        return resultList;
    }

    private void sendExportMergeProcessMsg(Integer cursor, Integer size, String taskCode) {
        Integer n = 40 + cursor * 40 / size;
        log.info("\u4e3b\u4efb\u52a1{},\u7b2c1\u9875,\u603b\u8ba1{},\u5f53\u524d\u8fdb\u5ea6{},{}", new Object[]{taskCode, size, cursor, n});
        ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
        msgVo.setTaskCode(taskCode);
        msgVo.setMainFlag(Boolean.valueOf(true));
        msgVo.setIsCombine(Boolean.valueOf(true));
        msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        msgVo.setProcessType(ExportProcessEnum.COMBINE.getCode());
        msgVo.setRemark(CharSequenceUtil.format((CharSequence)"\u4efb\u52a1{},\u603b\u8ba1{}\u4e2a\u5b50\u4efb\u52a1,\u5df2\u5408\u5e76{}\u4e2a", (Object[])new Object[]{taskCode, size, cursor}));
        msgVo.setPageSize(Integer.valueOf(100));
        msgVo.setAccount(this.loginUserService.getLoginAccountName());
        msgVo.setCursor(n);
        this.exportMsgBean.sendMsg(msgVo);
    }
}

