package com.biz.crm.common.ie.local.concurrent.threadpool;

import java.util.concurrent.RejectedExecutionHandler;
import cn.hutool.core.thread.RejectPolicy;
import lombok.Data;

/**
 * Crm线程池参数
 * 
 * @author Ken.xu
 *
 */
@Data
public class CrmThreadPoolParam {
  /** 最小池大小 */
  int corePoolSite = 5;
  /** 最大池大小 */
  int maxPoolSite = 5;
  /** 队列大小 */
  int queueCapacity = maxPoolSite > corePoolSite ? maxPoolSite : corePoolSite;
  /** 单位秒 */
  Long keepAliveTime = 1L;
  
  RejectedExecutionHandler rejectPolicy = RejectPolicy.CALLER_RUNS.getValue();

  /**
   * 5个线程
   * 
   * @param rejectPolicy
   * @see RejectPolicy
   */
  public CrmThreadPoolParam(RejectedExecutionHandler rejectPolicy) {
    this.rejectPolicy = rejectPolicy;
  }

  /**
   * 
   * @param corePoolSite
   * @param maxPoolSite
   * @param queueCapacity
   * @param keepAliveTime
   * @param rejectPolicy
   * @see RejectPolicy
   */
  public CrmThreadPoolParam(int corePoolSite, int maxPoolSite, int queueCapacity, long keepAliveTime,
      RejectedExecutionHandler rejectPolicy) {
    this.corePoolSite = corePoolSite;
    this.maxPoolSite = maxPoolSite;
    this.queueCapacity = queueCapacity;
    this.keepAliveTime = keepAliveTime;
    this.rejectPolicy = rejectPolicy;
  }

}
