package com.biz.crm.common.ie.local.concurrent.threadpool.priority;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;

/**
 * 专用于PriorityBlockingQueue的队列
 * 
 * @author xzkne
 *
 */
@Slf4j
public class ThreadPoolExecutorPriorityBlocking extends ThreadPoolExecutor {

  public ThreadPoolExecutorPriorityBlocking(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit,
      PriorityBlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
    super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
  }

  @Override
  public <T> FutureTaskComparable<T> submit(Callable<T> task) {
    if (task == null)
      throw new NullPointerException();
    FutureTaskComparable<T> ftask = newTaskFor(task);
    execute(ftask);
    return ftask;
  }

  /**
   * @throws RejectedExecutionException {@inheritDoc}
   * @throws NullPointerException {@inheritDoc}
   */
  public FutureTaskComparable<?> submit(Runnable task) {
    if (task == null)
      throw new NullPointerException();
    FutureTaskComparable<Void> ftask = newTaskFor(task, null);
    execute(ftask);
    return ftask;
  }

  /**
   * @throws RejectedExecutionException {@inheritDoc}
   * @throws NullPointerException {@inheritDoc}
   */
  public <T> FutureTaskComparable<T> submit(Runnable task, T result) {
    if (task == null)
      throw new NullPointerException();
    FutureTaskComparable<T> ftask = newTaskFor(task, result);
    execute(ftask);
    return ftask;
  }

  @Override
  protected <T> FutureTaskComparable<T> newTaskFor(Callable<T> callable) {
    return new FutureTaskComparable<T>(callable);
  }

  @Override
  public void execute(Runnable command) {
    super.execute(command);
  }

  /**
   * Returns a {@code RunnableFuture} for the given runnable and default value.
   *
   * @param runnable the runnable task being wrapped
   * @param value the default value for the returned future
   * @param <T> the type of the given value
   * @return a {@code RunnableFuture} which, when run, will run the underlying runnable and which, as
   *         a {@code Future}, will yield the given value as its result and provide for cancellation
   *         of the underlying task
   * @since 1.6
   */
  protected <T> FutureTaskComparable<T> newTaskFor(Runnable runnable, T value) {
    return new FutureTaskComparable<T>(runnable, value);
  }
}
