package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author HanJiaJun
 * @describe:  数据视图导出字段
 * @createTime 2023年07月25日 14:22:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_export_field")
@Table(
    name = "ie_export_field",
    indexes = {
        @Index(name = "ie_e_t_code_account", columnList = "tenant_code,account,menu_code"),
    })
@ApiModel(value = "ExportTask", description = "数据视图导出字段")
@org.hibernate.annotations.Table(appliesTo = "ie_export_field", comment = "数据视图导出字段")
public class ExportField extends TenantFlagOpEntity {
  /** 导出字段 */
  @ApiModelProperty("导出字段")
  @TableField(value = "field")
  @Column(name = "field", length = 64, columnDefinition = "varchar(64) COMMENT '导出字段'")
  private String field;

  /** 导出字段名称 */
  @ApiModelProperty("导出字段名称")
  @TableField(value = "title")
  @Column(name = "title", length = 64, columnDefinition = "varchar(64) COMMENT '导出字段名称'")
  private String title;

  /** 导出字段 */
  @ApiModelProperty("账号")
  @TableField(value = "account")
  @Column(name = "account", length = 64, columnDefinition = "varchar(64) COMMENT '账号'")
  private String account;


  /** 菜单列表编码 */
  @ApiModelProperty("菜单列表编码")
  @TableField(value = "menu_code")
  @Column(name = "menu_code", length = 128, columnDefinition = "varchar(128) COMMENT '菜单列表编码'")
  private String menuCode;

  /**
   * 字段排序
   */
  @ApiModelProperty("字段排序")
  @TableField(value = "form_order")
  @Column(name = "form_order", length = 11, columnDefinition = "int(11) COMMENT '字段排序'")
  private int formOrder;



}
