package com.biz.crm.common.ie.local.service.task;

import com.biz.crm.common.ie.local.config.ImportExportProperties;
import java.sql.SQLNonTransientConnectionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.hutool.core.thread.ThreadUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * 增量加载未加载的导入导出任务
 *
 * @author sunx
 * @date 2022/5/11
 */
@Component("_ImportExportReloadTask")
@Slf4j
public class ImportExportReloadTask implements Runnable {

  @Autowired private ImportExportLoadTask importExportLoadTask;

  @Autowired private ImportExportProperties importExportProperties;

  @Override
  public void run() {
    String applicationName = this.importExportProperties.getIeTaskGroup();
    long taskInterval = this.importExportProperties.getTaskInterval();
    log.info("******{}*****每隔{}ms加载任务", applicationName, taskInterval);
    
    while (true) {
//      log.warn("#################################################### 1");
//      log.info("#################################################### 2");
      try {
        this.importExportLoadTask.load(applicationName, false);
      } catch (Exception e) {
        log.error("WARN! WARN! WARN! 导入导出任务异常！", e);
      } finally {// 每隔 taskInterval ms加载任务
        ThreadUtil.safeSleep(taskInterval);
      }
    }
  }
}
