/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.sdk.dto.CreateImportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ImportTaskPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfc\u5165\u4efb\u52a1: ImportTask: \u5bfc\u5165\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/v1/importTask/importTask"})
public class ImportTaskController {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskController.class);
    @Autowired
    private ImportTaskService importTaskService;
    @Autowired
    private ImportExportProperties importExportProperties;

    @ApiOperation(value="\u521b\u5efa\u5bfc\u5165\u4efb\u52a1")
    @PostMapping(value={""})
    public Result<ImportTask> createImportTask(@RequestBody CreateImportTaskDto dto) {
        try {
            ImportTask importTask = new ImportTask();
            importTask.setTemplateCode(dto.getTemplateCode());
            importTask.setTaskSource(dto.getTaskSource());
            importTask.setFileCode(dto.getFileCode());
            importTask.setParametersJson(dto.getParametersJson());
            ImportTask current = this.importTaskService.create(importTask);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ImportTask>> findByConditions(@PageableDefault(value=50) Pageable pageable, ImportTaskPaginationDto paginationDto) {
        try {
            Page<ImportTask> result = this.importTaskService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/findDetailByTaskCode"})
    public Result<ImportTask> findDetailByTaskCode(@RequestParam(value="taskCode") String taskCode) {
        try {
            ImportTask importTask = this.importTaskService.findDetailByTaskCode(taskCode);
            return Result.ok((Object)((Object)importTask));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfc\u5165\u6587\u4ef6\u5927\u5c0f\u9650\u5236/mb")
    @GetMapping(value={"/findImportMaxSize"})
    public Result<Long> findImportMaxSize() {
        return Result.ok((Object)this.importExportProperties.getImportProperties().getExcelMaxSize().toMegabytes());
    }
}

