/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.model.vo.ImportTaskUpdateModelVo;
import com.biz.crm.common.ie.local.repository.ImportTaskRepository;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.configuration.MultiDataSourceProperties;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportTaskThreadLocalServImpl {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskThreadLocalServImpl.class);
    @Autowired(required=false)
    private ImportTaskRepository importTaskRepository;
    @Autowired
    private MultiDataSourceProperties multiDataSourceProperties;
    private static final Interner<String> TASKCODE_LOCKPOOL = Interners.newWeakInterner();
    private static final ThreadLocal<ImportTask> IMPORTTASK_THREADLOCAL = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportTask findByTaskCode(String taskCode) {
        ImportTask importTask = IMPORTTASK_THREADLOCAL.get();
        if (importTask == null) {
            String taskCodeIntern;
            String string = taskCodeIntern = (String)TASKCODE_LOCKPOOL.intern((Object)taskCode);
            synchronized (string) {
                if (importTask == null) {
                    importTask = this.importTaskRepository.findByTaskCode(taskCode);
                    IMPORTTASK_THREADLOCAL.set(importTask);
                    log.debug("\u7ebf\u7a0b{}\u52a0\u8f7d\u6570\u636e{}", (Object)Thread.currentThread().getId(), (Object)importTask);
                }
            }
        }
        return importTask;
    }

    public void clean() {
        IMPORTTASK_THREADLOCAL.remove();
    }

    public void updateByImportTaskUpdateModelVo(ImportTaskUpdateModelVo vo) {
        Validate.notNull((Object)vo, (String)"\u66f4\u65b0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)vo.getTaskCode(), (String)"\u66f4\u65b0\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)vo.getExecStatus(), (String)"\u4efb\u52a1\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String taskCode = vo.getTaskCode();
        ImportTask importTask = this.findByTaskCode(taskCode);
        if (StringUtils.equals((CharSequence)importTask.getTaskCode(), (CharSequence)vo.getTaskCode())) {
            importTask.setExecStatus(vo.getExecStatus());
            if (Objects.nonNull(vo.getTotal())) {
                importTask.setTotal(vo.getTotal());
            }
            if (Objects.nonNull(vo.getFailedNum())) {
                importTask.setFailedNum(vo.getFailedNum());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFailedFileCode())) {
                importTask.setFailedFileCode(vo.getFailedFileCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getRemark())) {
                importTask.setRemark(vo.getRemark());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getLoadStatus())) {
                importTask.setLoadStatus(vo.getLoadStatus());
            }
            if (vo.getImportDataStatus() != null) {
                importTask.setImportDataStatus(vo.getImportDataStatus().getDictCode());
            }
            if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
                importTask.setAppCode(TenantUtils.getAppCode());
            }
            this.importTaskRepository.updateById((Object)importTask);
        } else {
            log.warn("\u66f4\u65b0\u7684\u6570\u636eTaskCode\u4e0e\u7f13\u5b58\u4e0d\u540c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u56e2\u961f\u68c0\u67e5\u7a0b\u5e8f\uff01\uff01\uff01");
            this.importTaskRepository.updateByImportTaskUpdateModelVo(vo);
        }
    }
}

