package com.biz.crm.common.ie.local.context;

import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.google.common.collect.Maps;
import java.util.Map;
import lombok.Getter;
import lombok.Setter;

/**
 * @author ning.zhang
 * @description 导出任务上下文信息(此类用于记录获取导出任务的一些基础信息,以及一些动态参数,提供给项目在导出获取导出数据总数和具体导出数据时使用)
 * @date 2025/05/14
 */
public class ExportTaskContext {

  /**
   * 导出任务基础信息
   */
  @Getter
  @Setter
  private ExportTaskProcessVo taskProcessVo;

  /**
   * 导出任务参数信息
   */
  @Getter
  @Setter
  private Map<String, Object> taskParamsMap;

  /**
   * 自定义MAP,项目可以在此MAP中记录需要传递上下文参数
   */
  @Getter
  private final Map<String, Object> customParamsMap = Maps.newHashMap();
}
