package com.biz.crm.common.ie.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.sdk.enums.ImportDataStatusEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.Pair;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 导入导出: ImportExport: 枚举属性
 */
@Slf4j
@Api(tags = "导入导出: ImportExport: 枚举属性")
@RestController
@RequestMapping(value = {"/v1/ieEnum/ieEnum"})
public class IeEnumController {

  /**
   * 导入数据状态
   * 
   * @return
   */
  @ApiOperation(value = "根据任务编码获取详情")
  @GetMapping(value = {"/ImportDataStatusEnum"})
  public Result<List> ImportDataStatusEnum() {
    try {
      final com.biz.crm.common.ie.sdk.enums.ImportDataStatusEnum[] values = ImportDataStatusEnum.values();
      List<Map<String, String>> enumList = new ArrayList<>();
      for (ImportDataStatusEnum importDataStatusEnum : values) {
        final String dictCode = importDataStatusEnum.getDictCode();
        final String value = importDataStatusEnum.getValue();
        Map<String, String> row = new HashMap<>(2);
        row.put("dictCode", dictCode);
        row.put("value", value);
        enumList.add(row);
      }
      return Result.ok(enumList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
