package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IRequestParamParse;
import org.springframework.stereotype.Component;

/**
 * @title RequestParamParseForDouble
 * @date 2023/10/10 10:24
 * @author Kevin
 * @description double类型
 */
@Component
public class RequestParamParseForDouble implements IRequestParamParse<Double> {

  @Override
  public boolean isApplicable(Class<?> parameterType) {
    return parameterType == Double.TYPE;
  }

  @Override
  public Double getValue(String defaultValueString) throws IllegalArgumentException {
    return new Double(defaultValueString);
  }
}
