package com.biz.crm.common.ie.local.service.task;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.task.tools.TaskExecutorAuthTool;
import com.biz.crm.common.ie.sdk.service.ImportProcessService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForImport;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import cn.hutool.core.thread.ThreadUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * 导入任务执行
 *
 * @author sunx
 * @date 2022/5/11
 */
@Component("_IeTaskExecutorForImport")
@Scope("prototype")
@Lazy
@Slf4j
public class IeTaskExecutorForImport implements Runnable {
  /** 导入任务执行前置参数 */
  private IeExecutorVoForImport vo;
  /** 当前租户信息 */
  @Getter
  private AbstractTenantInfo tenantInfo;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private ImportProcessService importProcessService;
  @Autowired
  private ImportExportProperties importExportProperties;

  /** nebula security模块中，关于默认用户身份信息的配置情况 */
  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;
  
  public IeTaskExecutorForImport(IeExecutorVoForImport importExportExecutorVo, AbstractTenantInfo tenantInfo) {
    this.vo = importExportExecutorVo;
    this.tenantInfo = tenantInfo;
  }

  @Override
  public void run() {
    // 异步线程还原租户信息，切换数据源
    TenantContextHolder.setTenantInfo(tenantInfo);
    String appCode = TenantUtils.getAppCode();
    log.debug("******导入任务开始执行中*********{}", appCode);
    Integer defaultLoginType = simpleSecurityProperties.getDefaultLoginType();
    try {
      TaskExecutorAuthTool.refreshUseAuthAndTenantCode(loginUserService, vo, defaultLoginType); // 重建用户权限环境
      this.importProcessService.importProcess(vo);
    } catch (Exception e) {
      log.error("执行导入操作异常：", e);
    }
    log.debug("******导入任务开始执完成*********");
    long taskExecutionAfterSleep = importExportProperties.getTaskExecutionIntervalSleep();
    if (taskExecutionAfterSleep > 0) {
      ThreadUtil.sleep(taskExecutionAfterSleep);
      log.debug("******休眠释放数据库压力*********");
    }
  }
}
