/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.controller;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.bean.IeTaskCodeInfoVo;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u6587\u4ef6\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/v1/ieTask/ieTask"})
public class IeTaskController {
    private static final Logger log = LoggerFactory.getLogger(IeTaskController.class);
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private ExportTaskService exportTaskService;
    @Autowired
    private ImportTaskService importTaskService;

    @ApiOperation(value="\u4efb\u52a1\u6587\u4ef6\u67e5\u8be2")
    @PostMapping(value={"/getFileInfo"})
    public Result<?> getFileInfo(@RequestBody List<IeTaskCodeInfoVo> taskInfo) {
        try {
            String fileName;
            TenantFlagOpEntity task;
            ArrayList<String> importTaskInfo = new ArrayList<String>();
            ArrayList<String> exportTaskInfo = new ArrayList<String>();
            for (IeTaskCodeInfoVo row : taskInfo) {
                String taskType = row.getIeType();
                if (taskType == null) {
                    log.warn("\u524d\u7aef\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u65e0type\u3010imp/exp\u3011\uff1a{}", (Object)row);
                }
                if (TypeEnum.IMPORT.getDictCode().equals(taskType)) {
                    importTaskInfo.add(row.getTaskCode());
                    continue;
                }
                if (TypeEnum.EXPORT.getDictCode().equals(taskType)) {
                    exportTaskInfo.add(row.getTaskCode());
                    continue;
                }
                log.warn("\u524d\u7aef\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0ctype\u975e\u3010imp/exp\u3011\uff1a{}", (Object)taskType);
            }
            HashMap fileNameMap = Maps.newHashMap();
            for (String taskCode : exportTaskInfo) {
                task = this.exportTaskService.findExportTask(taskCode);
                if (task != null) {
                    fileName = task.getFileName();
                    fileNameMap.put(taskCode, fileName);
                    continue;
                }
                log.info("\u5bfc\u51fa\u4efb\u52a1\u65e0\u6cd5\u67e5\u8be2\u5230{}", (Object)taskCode);
            }
            for (String taskCode : importTaskInfo) {
                task = this.importTaskService.findDetailByTaskCode(taskCode);
                if (task != null) {
                    fileName = task.getFile().getFileName();
                    fileNameMap.put(taskCode, fileName);
                    continue;
                }
                log.info("\u5bfc\u5165\u4efb\u52a1\u65e0\u6cd5\u67e5\u8be2\u5230{}", (Object)taskCode);
            }
            return Result.ok((Object)fileNameMap);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

