/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import com.biz.crm.common.ie.local.model.vo.ImportTreeModelVo;
import com.biz.crm.common.ie.local.repository.ImportTemplateRepository;
import com.biz.crm.common.ie.local.service.ImportTemplateDetailService;
import com.biz.crm.common.ie.local.service.ImportTemplateService;
import com.biz.crm.common.ie.sdk.dto.ImportTemplatePaginationDto;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="importTemplateService")
public class ImportTemplateServiceImpl
implements ImportTemplateService {
    @Autowired
    private ImportTemplateRepository importTemplateRepository;
    @Autowired
    private ImportTemplateDetailService importTemplateDetailService;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private List<ImportProcess> importProcesses;

    @Override
    public Page<ImportTemplate> findByConditions(Pageable pageable, ImportTemplatePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ImportTemplatePaginationDto());
        dto.setApplicationName(this.getApplicationName());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.importTemplateRepository.findByConditions((Page<ImportTemplate>)page, dto);
    }

    private String getApplicationName() {
        return this.importExportProperties.getIeTaskGroup();
    }

    @Override
    public ImportTemplate findDetailByBusinessCode(String businessCode) {
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return null;
        }
        ImportTemplate template = this.importTemplateRepository.findByBusinessCode(businessCode);
        if (Objects.isNull((Object)template)) {
            return null;
        }
        List<ImportTemplateDetail> list = this.importTemplateDetailService.findDetailByBusinessCode(template.getBusinessCode());
        template.setList(list);
        return template;
    }

    @Override
    @Transactional
    public ImportTemplate create(ImportTemplate importTemplate) {
        this.validation(importTemplate);
        importTemplate.setTenantCode(TenantUtils.getTenantCode());
        this.importTemplateRepository.saveOrUpdate((Object)importTemplate);
        this.importTemplateDetailService.createBatch(importTemplate.getList(), importTemplate.getBusinessCode());
        return importTemplate;
    }

    @Override
    @Transactional
    public ImportTemplate update(ImportTemplate importTemplate) {
        this.validation(importTemplate);
        String currentId = importTemplate.getId();
        ImportTemplate current = this.importTemplateRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.importTemplateRepository.saveOrUpdate((Object)importTemplate);
        this.importTemplateDetailService.createBatch(importTemplate.getList(), importTemplate.getBusinessCode());
        return importTemplate;
    }

    @Override
    @Transactional
    public void deleteByBusinessCodes(List<String> businessCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(businessCodes), (String)"\u4e1a\u52a1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.importTemplateRepository.deleteByBusinessCodes(businessCodes);
        this.importTemplateDetailService.deleteByBusinessCodes(businessCodes);
    }

    @Override
    public List<ImportTreeModelVo> findTemplateTree() {
        if (CollectionUtils.isEmpty(this.importProcesses)) {
            return Lists.newLinkedList();
        }
        List<ImportTemplate> existList = this.importTemplateRepository.findByAppName(this.getApplicationName());
        Set set = existList.stream().map(ImportTemplate::getBusinessCode).collect(Collectors.toSet());
        ArrayList list = Lists.newArrayList();
        Map<String, List<ImportProcess>> mapList = this.importProcesses.stream().collect(Collectors.groupingBy(ImportProcess::getBusinessCode));
        Map<String, String> map = this.importProcesses.stream().collect(Collectors.toMap(ImportProcess::getBusinessCode, ImportProcess::getBusinessName, (a, b) -> a));
        List<ImportProcess> importProcesses = mapList.getOrDefault("", Lists.newLinkedList());
        for (ImportProcess item : importProcesses) {
            mapList.put(item.getTemplateCode(), Lists.newArrayList((Object[])new ImportProcess[]{item}));
            map.put(item.getTemplateCode(), item.getTemplateName());
        }
        map.keySet().stream().filter(StringUtils::isNotBlank).sorted().forEach(a -> {
            if (set.isEmpty() || !set.contains(a)) {
                ImportTreeModelVo cur = new ImportTreeModelVo();
                cur.setCode((String)a);
                cur.setName((String)map.get(a));
                ArrayList child = Lists.newArrayList();
                List list1 = (List)mapList.get(a);
                list1.stream().sorted(Comparator.comparing(ImportProcess::order)).forEach(b -> {
                    ImportTreeModelVo cur1 = new ImportTreeModelVo();
                    cur1.setCode(b.getTemplateCode());
                    cur1.setName(b.getTemplateName());
                    child.add(cur1);
                });
                cur.setChild(child);
                list.add(cur);
            }
        });
        return list;
    }

    @Override
    public List<ImportTreeModelVo> findTemplateSelectByBusinessCode(String businessCode) {
        if (CollectionUtils.isEmpty(this.importProcesses) || StringUtils.isBlank((CharSequence)businessCode)) {
            return Lists.newLinkedList();
        }
        HashMap map = Maps.newHashMap();
        this.importProcesses.stream().forEach(a -> {
            String code = StringUtils.isBlank((CharSequence)a.getBusinessCode()) ? a.getTemplateCode() : a.getBusinessCode();
            List list = map.getOrDefault(code, Lists.newArrayList());
            ImportTreeModelVo cur = new ImportTreeModelVo();
            cur.setCode(a.getTemplateCode());
            cur.setName(a.getTemplateName());
            cur.setOrder(a.order());
            list.add(cur);
            map.put(code, list);
        });
        List list = (List)map.get(businessCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newLinkedList();
        }
        return list.stream().sorted(Comparator.comparing(ImportTreeModelVo::getOrder)).collect(Collectors.toList());
    }

    private void validation(ImportTemplate importTemplate) {
        importTemplate.setApplicationName(this.getApplicationName());
        Validate.notNull((Object)((Object)importTemplate), (String)"\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importTemplate.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importTemplate.getBusinessName(), (String)"\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ImportTemplate entity = this.importTemplateRepository.findByBusinessCode(importTemplate.getBusinessCode());
        if (StringUtils.isBlank((CharSequence)importTemplate.getId()) && Objects.nonNull((Object)entity)) {
            Validate.isTrue((boolean)false, (String)"\u6a21\u677f\u4e1a\u52a1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        } else if (Objects.nonNull((Object)entity)) {
            Validate.isTrue((boolean)importTemplate.getId().equals(entity.getId()), (String)"\u6a21\u677f\u4e1a\u52a1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(importTemplate.getList()), (String)"\u6a21\u677f\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ImportTemplateDetail item : importTemplate.getList()) {
            item.setApplicationName(this.getApplicationName());
        }
    }
}

