/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpUtil {
    private static String publicIp;
    private static String[] urls;
    private static String regEx;
    private static Pattern pattern;

    private IpUtil() {
    }

    public static String getPublicIp() {
        if (publicIp != null && !"".equals(publicIp.trim())) {
            return publicIp;
        }
        for (String url : urls) {
            String result = IpUtil.getUrlResult(url);
            Matcher m = pattern.matcher(result);
            if (!m.find()) continue;
            publicIp = m.group();
            return publicIp;
        }
        return "";
    }

    private static String getUrlResult(String url) {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            return "";
        }
        return sb.toString();
    }

    public static String getLocalIp() {
        if (IpUtil.isWindowsOS()) {
            return IpUtil.getLocalIpForWindows();
        }
        return IpUtil.getLocalIpForLinux();
    }

    public static String getLocalIpForLinux() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    public static String getLocalIpForWindows() {
        String ip = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    static {
        urls = new String[]{"http://whatismyip.akamai.com", "http://icanhazip.com", "http://members.3322.org/dyndns/getip", "http://checkip.dyndns.com/", "http://pv.sohu.com/cityjson", "http://ip.taobao.com/service/getIpInfo.php?ip=myip", "http://www.ip168.com/json.do?view=myipaddress", "http://www.net.cn/static/customercare/yourip.asp", "http://ipecho.net/plain", "http://myip.dnsomatic.com", "http://tnx.nl/ip", "http://ifconfig.me"};
        regEx = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
        pattern = Pattern.compile(regEx);
    }
}

